/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.PortalManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalData;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalEntity;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalPos;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class PortalSpell
extends AbstractSpell {
    public static final int PORTAL_RECAST_COUNT = 2;
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "portal");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(3).setCooldownSeconds(180.0).build();

    public PortalSpell() {
        this.baseSpellPower = 300;
        this.spellPowerPerLevel = 120;
        this.baseManaCost = 200;
        this.manaCostPerLevel = 10;
        this.castTime = 0;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public ICastDataSerializable getEmptyCastData() {
        return new PortalData();
    }

    @Override
    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 blockHitResult = Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, this.getCastDistance(spellLevel, entity)).m_82450_().m_82546_(entity.m_20156_().m_82541_().m_82542_(0.25, 0.0, 0.25));
                Vec3 portalLocation = level.m_45547_(new ClipContext(blockHitResult, blockHitResult.m_82520_(0.0, (double)(-entity.m_20206_() - 1.0f), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_82450_().m_82520_(0.0, 0.076, 0.0);
                float portalRotation = 90.0f + Utils.getAngle(portalLocation.f_82479_, portalLocation.f_82481_, entity.m_20185_(), entity.m_20189_()) * 57.295776f;
                if (playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
                    PortalData portalData = (PortalData)playerMagicData.getPlayerRecasts().getRecastInstance(this.getSpellId()).getCastData();
                    if (portalData.globalPos1 != null & portalData.portalEntityId1 != null) {
                        PortalEntity firstPortalEntity;
                        portalData.globalPos2 = PortalPos.of((ResourceKey<Level>)player.f_19853_.m_46472_(), portalLocation, portalRotation);
                        portalData.setPortalDuration(this.getPortalDuration(spellLevel, (LivingEntity)player));
                        PortalEntity secondPortalEntity = this.setupPortalEntity((Level)serverLevel, portalData, player, portalLocation, portalRotation);
                        secondPortalEntity.setPortalConnected();
                        portalData.portalEntityId2 = secondPortalEntity.m_20148_();
                        PortalManager.INSTANCE.addPortalData(portalData.portalEntityId1, portalData);
                        PortalManager.INSTANCE.addPortalData(portalData.portalEntityId2, portalData);
                        ServerLevel firstPortalLevel = serverLevel.m_7654_().m_129880_(portalData.globalPos1.dimension());
                        if (firstPortalLevel != null && (firstPortalEntity = (PortalEntity)firstPortalLevel.m_8791_(portalData.portalEntityId1)) != null) {
                            firstPortalEntity.setPortalConnected();
                            firstPortalEntity.setTicksToLive(portalData.ticksToLive);
                        }
                    }
                } else {
                    PortalData portalData = new PortalData();
                    portalData.setPortalDuration(this.getRecastDuration(spellLevel, (LivingEntity)player) + 10);
                    PortalEntity portalEntity = this.setupPortalEntity(level, portalData, player, portalLocation, portalRotation);
                    portalData.globalPos1 = PortalPos.of((ResourceKey<Level>)player.f_19853_.m_46472_(), portalLocation, portalRotation);
                    portalData.portalEntityId1 = portalEntity.m_20148_();
                    playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, 2, this.getRecastDuration(spellLevel, (LivingEntity)player), castSource, portalData), playerMagicData);
                }
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private PortalEntity setupPortalEntity(Level level, PortalData portalData, Player owner, Vec3 spawnPos, float rotation) {
        PortalEntity portalEntity = new PortalEntity(level, portalData);
        portalEntity.setOwnerUUID(owner.m_20148_());
        portalEntity.m_20219_(spawnPos);
        portalEntity.m_146922_(rotation);
        level.m_7967_((Entity)portalEntity);
        return portalEntity;
    }

    @Override
    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult != RecastResult.USED_ALL_RECASTS && castDataSerializable instanceof PortalData) {
            ServerLevel level;
            MinecraftServer server;
            PortalData portalData = (PortalData)castDataSerializable;
            if (portalData.portalEntityId1 != null && portalData.globalPos1 != null && (server = serverPlayer.m_20194_()) != null && (level = server.m_129880_(portalData.globalPos1.dimension())) != null) {
                Entity portal1 = level.m_8791_(portalData.portalEntityId1);
                if (portal1 != null) {
                    portal1.m_146870_();
                } else {
                    PortalManager.INSTANCE.removePortalData(portalData.portalEntityId1);
                }
            }
        }
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
    }

    public int getRecastDuration(int spellLevel, LivingEntity caster) {
        return 2400;
    }

    public int getPortalDuration(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
    }

    private float getCastDistance(int spellLevel, LivingEntity sourceEntity) {
        return 48.0f;
    }

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.cast_range", (Object[])new Object[]{Utils.stringTruncation(this.getCastDistance(spellLevel, caster), 1)}), Component.m_237110_((String)"ui.irons_spellbooks.portal_duration", (Object[])new Object[]{Utils.timeFromTicks(this.getPortalDuration(spellLevel, caster), 2)}));
    }
}

