/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin.AccessorAbstractContraptionEntity;
import com.railwayteam.railways.mixin.AccessorOrientedContraptionEntity;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.mixin_interfaces.IStrictSignalTrain;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.AddTrainEndPacket;
import com.railwayteam.railways.util.packet.CarriageContraptionEntityUpdatePacket;
import com.railwayteam.railways.util.packet.ChopTrainEndPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionDisassemblyPacket;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;

public class TrainUtils {
    public static Train splitTrain(Train train, int numberOffEnd) {
        Train newTrain;
        if (((IHandcarTrain)train).railways$isHandcar()) {
            return train;
        }
        if (numberOffEnd == 0) {
            return train;
        }
        if (train.carriages.size() <= numberOffEnd) {
            return train;
        }
        if (!TrainUtils.allCarriagesLoaded(train)) {
            return train;
        }
        Integer frontSpacingBackup = null;
        Carriage[] lastCarriages = new Carriage[numberOffEnd];
        Integer[] lastCarriageSpacings = new Integer[numberOffEnd - 1];
        for (int i = numberOffEnd - 1; i >= 0; --i) {
            lastCarriages[i] = (Carriage)train.carriages.remove(train.carriages.size() - 1);
            if (i > 0) {
                lastCarriageSpacings[i - 1] = (Integer)train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
                continue;
            }
            frontSpacingBackup = (Integer)train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
        }
        double[] originalStress = ((AccessorTrain)train).railways$getStress();
        double[] newStress = new double[originalStress.length - numberOffEnd];
        System.arraycopy(originalStress, 0, newStress, 0, newStress.length);
        ((AccessorTrain)train).railways$setStress(newStress);
        try {
            newTrain = new Train(UUID.randomUUID(), train.owner, train.graph, new ArrayList<Carriage>(List.of(lastCarriages)), new ArrayList<Integer>(List.of(lastCarriageSpacings)), Arrays.stream(lastCarriages).anyMatch(carriage -> {
                CarriageContraption carriageContraption;
                Contraption patt4022$temp = carriage.anyAvailableEntity().getContraption();
                return patt4022$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt4022$temp).hasBackwardControls();
            }));
        }
        catch (NullPointerException e) {
            train.carriages.addAll(List.of(lastCarriages));
            if (frontSpacingBackup != null) {
                train.carriageSpacing.add(frontSpacingBackup);
            }
            train.carriageSpacing.addAll(List.of(lastCarriageSpacings));
            ((AccessorTrain)train).railways$setStress(originalStress);
            return train;
        }
        train.doubleEnded = train.carriages.stream().anyMatch(carriage -> {
            CarriageContraption carriageContraption;
            Contraption patt4633$temp = carriage.anyAvailableEntity().getContraption();
            return patt4633$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt4633$temp).hasBackwardControls();
        });
        newTrain.name = !train.name.getString().contains("Split off from: ") ? Components.literal((String)("Split off from: " + train.name.getString())) : Components.literal((String)train.name.getString());
        int i = 0;
        while (i < lastCarriages.length) {
            Carriage lastCarriage = lastCarriages[i];
            int finalI = i++;
            lastCarriage.forEachPresentEntity(cce -> {
                cce.carriageIndex = finalI;
                cce.trainId = newTrain.id;
                cce.setCarriage(lastCarriage);
                cce.syncCarriage();
            });
        }
        double bufferDist = 0.1;
        Carriage leadingCarriage = (Carriage)newTrain.carriages.get(0);
        TravellingPoint returnPoint = TrainUtils.copy(leadingCarriage.getLeadingPoint());
        leadingCarriage.travel(null, newTrain.graph, -0.1, null, null, 0);
        newTrain.collectInitiallyOccupiedSignalBlocks();
        ((IStrictSignalTrain)newTrain).railways$setStrictSignals(true);
        leadingCarriage.travel(null, newTrain.graph, 0.1, returnPoint, null, 0);
        ((IStrictSignalTrain)newTrain).railways$setStrictSignals(false);
        newTrain.collectInitiallyOccupiedSignalBlocks();
        train.updateSignalBlocks = true;
        Create.RAILWAYS.addTrain(newTrain);
        CRPackets.PACKETS.sendTo(PlayerSelection.all(), (SimplePacketBase)new TrainPacket(newTrain, true));
        Arrays.stream(lastCarriages).forEach(c -> c.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        train.carriages.forEach(carriage -> carriage.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        newTrain.carriages.forEach(carriage -> carriage.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        PlayerSelection allPlayers = PlayerSelection.all();
        Arrays.stream(lastCarriages).forEach(c -> c.forEachPresentEntity(cce -> CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new CarriageContraptionEntityUpdatePacket((CarriageContraptionEntity)cce, newTrain))));
        CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new ChopTrainEndPacket(train, numberOffEnd, train.doubleEnded));
        if (train.runtime.getSchedule() != null && ((IIndexedSchedule)train).railways$getIndex() >= train.carriages.size()) {
            int newIndex = ((IIndexedSchedule)train).railways$getIndex() - train.carriages.size();
            ((IIndexedSchedule)newTrain).railways$setIndex(newIndex);
            newTrain.runtime.read(train.runtime.write());
            if (train.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                newTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ((AccessorScheduleRuntime)newTrain.runtime).setCooldown(0);
            }
            train.runtime.discardSchedule();
            Railways.LOGGER.info("[DISCARD_SCHEDULE] on train {} called in TrainUtils.splitTrain because it was transferred to a decoupled rear train because the train's schedule index {} was at least the carriage count {}", new Object[]{train.name.getString(), ((IIndexedSchedule)train).railways$getIndex(), train.carriages.size()});
        }
        if (train.carriages.isEmpty()) {
            Create.RAILWAYS.removeTrain(train.id);
        }
        TrainUtils.tryToParkNearby(newTrain, 0.75);
        newTrain.collectInitiallyOccupiedSignalBlocks();
        return newTrain;
    }

    public static void tryToParkNearby(Train train, double maxDistance) {
        double offsetDist = 0.05;
        Carriage leadingCarriage = (Carriage)train.carriages.get(0);
        leadingCarriage.travel(null, train.graph, -0.05, null, null, 0);
        TravellingPoint discoveryPoint = TrainUtils.copy(leadingCarriage.getLeadingPoint());
        MutableObject targetStation = new MutableObject(null);
        double distance = discoveryPoint.travel(train.graph, maxDistance + 0.05, discoveryPoint.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0)), (a, couple) -> {
            GlobalStation station;
            Object patt9719$temp = couple.getFirst();
            if (patt9719$temp instanceof GlobalStation && (station = (GlobalStation)patt9719$temp).canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) && (station.getNearestTrain() == null || station.getNearestTrain() == train) && station.getPresentTrain() == null) {
                targetStation.setValue((Object)station);
                return true;
            }
            return false;
        });
        if (targetStation.getValue() != null) {
            Navigation oldNavigation = train.navigation;
            ScheduleRuntime oldRuntime = train.runtime;
            train.navigation = new Navigation(train);
            train.runtime = new ScheduleRuntime(train);
            train.navigation.destination = (GlobalStation)targetStation.getValue();
            leadingCarriage.travel(null, train.graph, Math.max(0.01, distance) + 0.05, discoveryPoint, null, 0);
            ((GlobalStation)targetStation.getValue()).reserveFor(train);
            train.navigation.train = null;
            train.runtime = oldRuntime;
            train.navigation = oldNavigation;
        } else {
            ((IStrictSignalTrain)train).railways$setStrictSignals(true);
            leadingCarriage.travel(null, train.graph, 0.05, null, null, 0);
            ((IStrictSignalTrain)train).railways$setStrictSignals(false);
        }
    }

    private static TravellingPoint copy(TravellingPoint original) {
        TravellingPoint copy = new TravellingPoint(original.node1, original.node2, original.edge, original.position, original.upsideDown);
        copy.blocked = original.blocked;
        return copy;
    }

    public static Train combineTrains(Train frontTrain, Train backTrain, BlockPos itemDropPos, Level itemDropLevel, int carriageSpacing) {
        return TrainUtils.combineTrains(frontTrain, backTrain, Vec3.m_82539_((Vec3i)itemDropPos), itemDropLevel, carriageSpacing);
    }

    public static Train combineTrains(Train frontTrain, Train backTrain, Vec3 itemDropPos, Level itemDropLevel, int carriageSpacing) {
        if (((IHandcarTrain)frontTrain).railways$isHandcar() || ((IHandcarTrain)backTrain).railways$isHandcar()) {
            return frontTrain;
        }
        if (frontTrain.derailed || backTrain.derailed) {
            return frontTrain;
        }
        if (!TrainUtils.allCarriagesLoaded(frontTrain) || !TrainUtils.allCarriagesLoaded(backTrain)) {
            return frontTrain;
        }
        int frontTrainSize = frontTrain.carriages.size();
        frontTrain.carriages.addAll(backTrain.carriages);
        backTrain.carriages.clear();
        frontTrain.carriageSpacing.add(carriageSpacing);
        frontTrain.carriageSpacing.addAll(backTrain.carriageSpacing);
        backTrain.carriageSpacing.clear();
        double[] newStress = new double[((AccessorTrain)frontTrain).railways$getStress().length + ((AccessorTrain)backTrain).railways$getStress().length + 1];
        System.arraycopy(((AccessorTrain)frontTrain).railways$getStress(), 0, newStress, 0, ((AccessorTrain)frontTrain).railways$getStress().length);
        newStress[((AccessorTrain)frontTrain).railways$getStress().length] = 0.0;
        System.arraycopy(((AccessorTrain)backTrain).railways$getStress(), 0, newStress, ((AccessorTrain)frontTrain).railways$getStress().length + 1, ((AccessorTrain)backTrain).railways$getStress().length);
        ((AccessorTrain)frontTrain).railways$setStress(newStress);
        frontTrain.doubleEnded = frontTrain.carriages.stream().anyMatch(carriage -> {
            CarriageContraption carriageContraption;
            Contraption patt13373$temp = carriage.anyAvailableEntity().getContraption();
            return patt13373$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt13373$temp).hasBackwardControls();
        });
        for (int i = 0; i < frontTrain.carriages.size(); ++i) {
            int finalI = i;
            Carriage lastCarriage = (Carriage)frontTrain.carriages.get(i);
            lastCarriage.setTrain(frontTrain);
            ((Carriage)frontTrain.carriages.get(i)).forEachPresentEntity(cce -> {
                cce.carriageIndex = finalI;
                cce.trainId = frontTrain.id;
                cce.setCarriage(lastCarriage);
            });
        }
        if (backTrain.getCurrentStation() != null) {
            backTrain.getCurrentStation().cancelReservation(backTrain);
        }
        frontTrain.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.removeTrain(backTrain.id);
        PlayerSelection allPlayers = PlayerSelection.all();
        CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new AddTrainEndPacket(frontTrain, backTrain, carriageSpacing, backTrain.doubleEnded));
        frontTrain.carriages.forEach(carriage -> carriage.forEachPresentEntity(cce -> CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new CarriageContraptionEntityUpdatePacket((CarriageContraptionEntity)cce, frontTrain))));
        if (frontTrain.runtime.getSchedule() == null && backTrain.runtime.getSchedule() != null) {
            ((IIndexedSchedule)frontTrain).railways$setIndex(((IIndexedSchedule)backTrain).railways$getIndex() + frontTrainSize);
            frontTrain.runtime.read(backTrain.runtime.write());
            if (backTrain.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                frontTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ((AccessorScheduleRuntime)frontTrain.runtime).setCooldown(0);
            }
        } else if (backTrain.runtime.getSchedule() != null) {
            if (frontTrain.runtime.completed) {
                ItemStack stack = frontTrain.runtime.returnSchedule();
                Containers.m_18992_((Level)itemDropLevel, (double)itemDropPos.f_82479_, (double)itemDropPos.f_82480_, (double)itemDropPos.f_82481_, (ItemStack)stack);
                ((IIndexedSchedule)frontTrain).railways$setIndex(((IIndexedSchedule)backTrain).railways$getIndex() + frontTrainSize);
                frontTrain.runtime.read(backTrain.runtime.write());
                if (backTrain.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                    frontTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                    ((AccessorScheduleRuntime)frontTrain.runtime).setCooldown(0);
                }
            } else {
                ItemStack stack = backTrain.runtime.returnSchedule();
                Containers.m_18992_((Level)itemDropLevel, (double)itemDropPos.f_82479_, (double)itemDropPos.f_82480_, (double)itemDropPos.f_82481_, (ItemStack)stack);
            }
        }
        return frontTrain;
    }

    public static boolean allCarriagesLoaded(Train train) {
        for (Carriage carriage : train.carriages) {
            if (carriage.anyAvailableEntity() != null) continue;
            return false;
        }
        return true;
    }

    public static void discardTrain(Train train) {
        for (Carriage carriage : train.carriages) {
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) continue;
            StructureTransform transform = ((AccessorOrientedContraptionEntity)entity).railways$makeStructureTransform();
            CRPackets.PACKETS.sendTo(PlayerSelection.tracking((Entity)entity), (SimplePacketBase)new ContraptionDisassemblyPacket(entity.m_19879_(), transform));
            entity.getContraption().addPassengersToWorld(entity.f_19853_, transform, entity.m_20197_());
            ((AccessorAbstractContraptionEntity)entity).railways$setSkipActorStop(true);
            entity.m_146870_();
            entity.m_20153_();
            ((AccessorAbstractContraptionEntity)entity).railways$moveCollidedEntitiesOnDisassembly(transform);
        }
        train.invalid = true;
    }
}

