/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.multiloader;

import com.railwayteam.railways.multiloader.forge.EnvImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public enum Env {
    CLIENT,
    SERVER;

    public static final Env CURRENT;

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public void runIfCurrent(Supplier<Runnable> run) {
        if (this.isCurrent()) {
            run.get().run();
        }
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (CURRENT) {
            default -> throw new IncompatibleClassChangeError();
            case CLIENT -> clientTarget.get().get();
            case SERVER -> serverTarget.get().get();
        };
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getCurrent() {
        return EnvImpl.getCurrent();
    }

    static {
        CURRENT = Env.getCurrent();
    }
}

