/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerServer;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.utility.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BogeyStyleSelectionPacket
implements C2SPacket {
    final BogeyStyle style;
    @Nullable
    final BogeySizes.BogeySize size;

    public BogeyStyleSelectionPacket(@NotNull BogeyStyle style) {
        this(style, null);
    }

    public BogeyStyleSelectionPacket(@NotNull BogeyStyle style, @Nullable BogeySizes.BogeySize size) {
        this.style = style;
        this.size = size;
    }

    public BogeyStyleSelectionPacket(FriendlyByteBuf buf) {
        ResourceLocation loc = buf.m_130281_();
        this.style = AllBogeyStyles.BOGEY_STYLES.getOrDefault(loc, AllBogeyStyles.STANDARD);
        if (buf.readBoolean()) {
            ResourceLocation sizeLoc = buf.m_130281_();
            this.size = BogeySizes.getAllSizesSmallToLarge().stream().filter(s -> s.location().equals((Object)sizeLoc)).findFirst().orElse(null);
        } else {
            this.size = null;
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.style.name);
        buffer.writeBoolean(this.size != null);
        if (this.size != null) {
            buffer.m_130085_(this.size.location());
        }
    }

    @Override
    public void handle(ServerPlayer sender) {
        BogeyMenuHandlerServer.addStyle(sender.m_20148_(), (Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)this.style, (Object)this.size));
    }
}

