/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.ui.render.AdvancementPlaque;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.google.common.collect.Queues;
import dev.shadowsoffire.toastcontrol.BetterToastComponent;
import java.util.Arrays;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AdvancementPlaquesToastGuiWithToastControl
extends BetterToastComponent {
    private final AdvancementPlaque[] plaques = new AdvancementPlaque[3];
    private final Deque<AdvancementToast> advancementToastsQueue = Queues.newArrayDeque();
    private final Minecraft mc;
    private final CustomItemRenderer itemRenderer;

    public AdvancementPlaquesToastGuiWithToastControl(Minecraft mcIn) {
        this.mc = mcIn;
        this.itemRenderer = new CustomItemRenderer(this.mc.m_91097_(), this.mc.m_91304_(), this.mc.getItemColors(), this.mc.m_91291_().getBlockEntityRenderer(), this.mc);
    }

    public void m_94922_(Toast toastIn) {
        if (toastIn instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toastIn;
            if (AdvancementPlaquesConfig.showPlaqueForAdvancement(advancementToast.f_94795_)) {
                this.advancementToastsQueue.add((AdvancementToast)toastIn);
                return;
            }
        }
        super.m_94922_(toastIn);
    }

    public void m_94920_(GuiGraphics graphics) {
        if (!this.mc.f_91066_.f_92062_) {
            try {
                super.m_94920_(graphics);
                boolean wailaLoaded = ModList.get().isLoaded("waila");
                boolean jadeLoaded = ModList.get().isLoaded("jade");
                if (((Boolean)AdvancementPlaquesConfig.INSTANCE.hideWaila.get()).booleanValue() && (wailaLoaded || jadeLoaded)) {
                    boolean anyPlaques = false;
                    for (int i = 0; i < this.plaques.length; ++i) {
                        if (this.plaques[i] == null) continue;
                        anyPlaques = true;
                        break;
                    }
                    if (anyPlaques) {
                        if (wailaLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("disableWaila", new Class[0]).invoke(null, new Object[0]);
                        }
                        if (jadeLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.JadeHandler").getMethod("disableJade", new Class[0]).invoke(null, new Object[0]);
                        }
                    } else {
                        if (wailaLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("enableWaila", new Class[0]).invoke(null, new Object[0]);
                        }
                        if (jadeLoaded) {
                            Class.forName("com.anthonyhilyard.advancementplaques.compat.JadeHandler").getMethod("enableJade", new Class[0]).invoke(null, new Object[0]);
                        }
                    }
                }
                for (int i = 0; i < this.plaques.length; ++i) {
                    AdvancementPlaque toastinstance = this.plaques[i];
                    if (toastinstance != null && toastinstance.render(graphics.m_280182_(), i, graphics)) {
                        this.plaques[i] = null;
                    }
                    if (this.plaques[i] != null || this.advancementToastsQueue.isEmpty()) continue;
                    this.plaques[i] = new AdvancementPlaque(this.advancementToastsQueue.removeFirst(), this.mc, this.itemRenderer);
                }
            }
            catch (Exception e) {
                AdvancementPlaques.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void m_94919_() {
        super.m_94919_();
        Arrays.fill(this.plaques, null);
        this.advancementToastsQueue.clear();
    }
}

