/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.serverpause.common.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.serverpause.common.ServerPause;
import me.ichun.mods.serverpause.common.core.PauseCommand;
import me.ichun.mods.serverpause.common.network.packet.PacketServerPause;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EventHandlerServer {
    public HashMap<UUID, Boolean> pauseState = new HashMap();
    public boolean isPaused;
    public boolean serverPaused;
    public boolean forcePause;
    public boolean wasForcePaused;

    public EventHandlerServer() {
        iChunUtil.eS().registerPlayerLoggedInListener(this::onPlayerLogin);
        iChunUtil.eS().registerPlayerLoggedOutListener(this::onPlayerLogout);
        iChunUtil.eS().registerServerAboutToStartListener(server -> this.resetServer((MinecraftServer)server, true));
        iChunUtil.eS().registerServerStoppingListener(server -> this.resetServer((MinecraftServer)server, false));
        iChunUtil.eS().registerCommandRegistrationListener(this::registerPauseCommand);
    }

    public void onPlayerLogin(Player player) {
        this.pauseState.put(player.m_36316_().getId(), false);
        this.checkAndUpdatePauseState();
        if ((ServerPause.modProxy.getServer().m_6982_() || this.pauseState.size() != 1) && ServerPause.config.sendChatMessageWhenPlayerPauseStateChanges) {
            int pauseCount = 0;
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                ++pauseCount;
            }
            if (pauseCount > 0) {
                String prefix = pauseCount + "/" + this.pauseState.size();
                MutableComponent chat = Component.m_237110_((String)"serverpause.message.playersPaused", (Object[])new Object[]{prefix});
                player.m_213846_((Component)chat);
            }
        }
        if (this.isPaused) {
            ServerPause.channel.sendTo((AbstractPacket)new PacketServerPause(true), (ServerPlayer)player);
            if ((ServerPause.modProxy.getServer().m_6982_() || this.pauseState.size() != 1) && (this.forcePause || this.wasForcePaused || ServerPause.config.sendChatMessageWhenPauseStateChanges)) {
                player.m_213846_((Component)Component.m_237115_((String)"serverpause.message.paused"));
            }
        }
    }

    public void onPlayerLogout(Player player) {
        this.pauseState.remove(player.m_36316_().getId());
        this.checkAndUpdatePauseState();
    }

    public void updatePlayerState(Player player, boolean paused) {
        Boolean wasPaused = this.pauseState.put(player.m_36316_().getId(), paused);
        if (ServerPause.modProxy.getServer() != null && (ServerPause.modProxy.getServer().m_6982_() || this.pauseState.size() != 1) && ServerPause.config.sendChatMessageWhenPlayerPauseStateChanges && (wasPaused == null || wasPaused != paused)) {
            String playerName = player.m_36316_().getName();
            int pauseCount = 0;
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                ++pauseCount;
            }
            String prefix = "(" + pauseCount + "/" + this.pauseState.size() + ") ";
            ServerPause.modProxy.getServer().m_213846_((Component)Component.m_237113_((String)(paused ? prefix + playerName + " paused." : prefix + playerName + " unpaused.")));
            MutableComponent chat = Component.m_237110_((String)(paused ? "serverpause.message.playerPaused" : "serverpause.message.playerUnpaused"), (Object[])new Object[]{prefix + playerName});
            for (ServerPlayer player1 : ServerPause.modProxy.getServer().m_6846_().m_11314_()) {
                player1.m_213846_((Component)chat);
            }
        }
        this.checkAndUpdatePauseState();
    }

    public void registerPauseCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        PauseCommand.register(dispatcher);
    }

    public void toggleForcePause() {
        this.wasForcePaused = this.forcePause;
        this.forcePause = !this.forcePause;
        this.checkAndUpdatePauseState();
    }

    public void checkAndUpdatePauseState() {
        boolean shouldPause = ServerPause.config.pauseWhenAllPlayersPaused;
        if (this.pauseState.isEmpty()) {
            shouldPause = (this.forcePause || ServerPause.config.pauseWhenNoPlayers) && ServerPause.modProxy.getServer() != null && ServerPause.modProxy.getServer().m_6982_();
        } else if (!this.forcePause && ServerPause.config.pauseWhenAllPlayersPaused) {
            for (Map.Entry<UUID, Boolean> e : this.pauseState.entrySet()) {
                if (e.getValue().booleanValue()) continue;
                shouldPause = false;
                break;
            }
        }
        if (this.isPaused != shouldPause && ServerPause.modProxy.getServer() != null) {
            this.isPaused = shouldPause;
            ServerPause.channel.sendToAll((AbstractPacket)new PacketServerPause(this.isPaused));
            if ((ServerPause.modProxy.getServer().m_6982_() || this.pauseState.size() != 1) && (this.forcePause || this.wasForcePaused || ServerPause.config.sendChatMessageWhenPauseStateChanges)) {
                ServerPause.modProxy.getServer().m_213846_((Component)Component.m_237113_((String)(this.isPaused ? "Server paused." : "Server unpaused.")));
                MutableComponent chat = Component.m_237115_((String)(this.isPaused ? "serverpause.message.paused" : "serverpause.message.unpaused"));
                for (ServerPlayer player : ServerPause.modProxy.getServer().m_6846_().m_11314_()) {
                    player.m_213846_((Component)chat);
                }
            }
        }
        this.wasForcePaused = false;
    }

    public void resetServer(MinecraftServer server, boolean starting) {
        this.pauseState.clear();
        this.isPaused = starting && ServerPause.config.pauseWhenNoPlayers && server.m_6982_();
        this.serverPaused = false;
        this.wasForcePaused = false;
        this.forcePause = false;
    }
}

