/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.tile.TileAlchemyTable;

public class BlockAlchemyTable
extends Block
implements EntityBlock {
    public static final DirectionProperty DIRECTION = DirectionProperty.m_61546_((String)"direction", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    protected static final VoxelShape BODY = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlockAlchemyTable() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 5.0f).m_60955_().m_60924_(BlockAlchemyTable::isntSolid).m_60971_(BlockAlchemyTable::isntSolid).m_60999_());
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BODY;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAlchemyTable(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            return null;
        }
        return (level1, blockPos, blockState, tile) -> {
            if (tile instanceof TileAlchemyTable) {
                ((TileAlchemyTable)tile).tick();
            }
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileAlchemyTable) {
            if (((TileAlchemyTable)tile).isSlave()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)world.m_7702_(((TileAlchemyTable)tile).getConnectedPos())), (BlockPos)((TileAlchemyTable)tile).getConnectedPos());
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tile), (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION, INVISIBLE});
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockPos connectedPos;
        BlockEntity connectedTile;
        TileAlchemyTable tile = (TileAlchemyTable)world.m_7702_(pos);
        if (!(tile == null || (connectedTile = world.m_7702_(connectedPos = tile.getConnectedPos())) instanceof TileAlchemyTable && ((TileAlchemyTable)connectedTile).getConnectedPos().equals((Object)pos))) {
            tile.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        TileAlchemyTable forge = (TileAlchemyTable)world.m_7702_(blockPos);
        if (forge != null && !forge.isSlave()) {
            forge.dropItems();
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof TileAlchemyTable && !((TileAlchemyTable)tileentity).isSlave()) {
                ((TileAlchemyTable)tileentity).dropItems();
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public Item m_5456_() {
        return (Item)BloodMagicItems.ALCHEMY_TABLE_ITEM.get();
    }
}

