/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemInventory
implements Container {
    protected int[] syncedSlots = new int[0];
    protected ItemStack masterStack;
    protected NonNullList<ItemStack> inventory;
    private int size;
    private String name;

    public ItemInventory(ItemStack masterStack, int size, String name) {
        this.inventory = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.size = size;
        this.name = name;
        this.masterStack = masterStack;
        if (!masterStack.m_41619_()) {
            this.readFromStack(masterStack);
        }
    }

    public void initializeInventory(ItemStack masterStack) {
        this.masterStack = masterStack;
        this.m_6211_();
        this.readFromStack(masterStack);
    }

    private boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void readFromNBT(CompoundTag tagCompound) {
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tagCompound, this.inventory);
    }

    public void writeToNBT(CompoundTag tagCompound) {
        ContainerHelper.m_18973_((CompoundTag)tagCompound, this.inventory);
    }

    public void readFromStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            CompoundTag tag = masterStack.m_41783_();
            this.readFromNBT(tag.m_128469_("itemInventory" + this.name));
        }
    }

    public void writeToStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            CompoundTag tag = masterStack.m_41783_();
            CompoundTag invTag = new CompoundTag();
            this.writeToNBT(invTag);
            tag.m_128365_("itemInventory" + this.name, (Tag)invTag);
        }
    }

    public int m_6643_() {
        return this.size;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.inventory.get(index)).m_41619_()) {
            if (((ItemStack)this.inventory.get(index)).m_41613_() <= count) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.inventory.get(index)).m_41620_(count);
            if (((ItemStack)this.inventory.get(index)).m_41619_()) {
                this.inventory.set(index, (Object)ItemStack.f_41583_);
            }
            this.m_6596_();
            return itemStack;
        }
        return null;
    }

    public ItemStack m_8016_(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).m_41619_()) {
            ItemStack itemStack = (ItemStack)this.inventory.get(slot);
            this.m_6836_(slot, ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void m_6596_() {
        if (this.masterStack != null) {
            this.writeToStack(this.masterStack);
        }
    }

    public boolean m_7983_() {
        return false;
    }

    public boolean canInventoryBeManipulated() {
        return this.masterStack != null;
    }
}

