/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wayoftime.bloodmagic.common.tile.base.TileBase;

public class TileInventory
extends TileBase
implements Container {
    protected int[] syncedSlots = new int[0];
    protected NonNullList<ItemStack> inventory;
    LazyOptional<IItemHandler> handlerDown;
    LazyOptional<IItemHandler> handlerUp;
    LazyOptional<IItemHandler> handlerNorth;
    LazyOptional<IItemHandler> handlerSouth;
    LazyOptional<IItemHandler> handlerWest;
    LazyOptional<IItemHandler> handlerEast;
    private int size;
    private String name;

    public TileInventory(BlockEntityType<?> type, int size, String name, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.size = size;
        this.name = name;
        this.initializeItemHandlers();
    }

    protected boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deserialize(CompoundTag tagCompound) {
        super.deserialize(tagCompound);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tagCompound, this.inventory);
    }

    @Override
    public CompoundTag serialize(CompoundTag tagCompound) {
        super.serialize(tagCompound);
        ContainerHelper.m_18973_((CompoundTag)tagCompound, this.inventory);
        return tagCompound;
    }

    public void dropItems() {
        Containers.m_19002_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (Container)this);
    }

    public int m_6643_() {
        return this.size;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (!this.m_8020_(index).m_41619_()) {
            if (!this.m_58904_().f_46443_) {
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
            }
            if (this.m_8020_(index).m_41613_() <= count) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.inventory.get(index)).m_41620_(count);
            this.m_6596_();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).m_41619_()) {
            ItemStack itemStack = (ItemStack)this.inventory.get(slot);
            this.m_6836_(slot, ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
        if (!this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58904_().m_8055_(this.m_58899_()), this.m_58904_().m_8055_(this.m_58899_()), 3);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
        this.inventory = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    protected void initializeItemHandlers() {
        if (this instanceof WorldlyContainer) {
            this.handlerDown = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.DOWN));
            this.handlerUp = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.UP));
            this.handlerNorth = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.NORTH));
            this.handlerSouth = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.SOUTH));
            this.handlerWest = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.WEST));
            this.handlerEast = LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, Direction.EAST));
        } else {
            this.handlerDown = LazyOptional.of(() -> new InvWrapper((Container)this));
            this.handlerUp = this.handlerDown;
            this.handlerNorth = this.handlerDown;
            this.handlerSouth = this.handlerDown;
            this.handlerWest = this.handlerDown;
            this.handlerEast = this.handlerDown;
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            switch (facing) {
                case DOWN: {
                    return this.handlerDown.cast();
                }
                case EAST: {
                    return this.handlerEast.cast();
                }
                case NORTH: {
                    return this.handlerNorth.cast();
                }
                case SOUTH: {
                    return this.handlerSouth.cast();
                }
                case UP: {
                    return this.handlerUp.cast();
                }
                case WEST: {
                    return this.handlerWest.cast();
                }
            }
        } else if (facing == null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerDown.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.handlerDown != null) {
            this.handlerDown.invalidate();
        }
        if (this.handlerEast != null) {
            this.handlerEast.invalidate();
        }
        if (this.handlerNorth != null) {
            this.handlerNorth.invalidate();
        }
        if (this.handlerSouth != null) {
            this.handlerSouth.invalidate();
        }
        if (this.handlerUp != null) {
            this.handlerUp.invalidate();
        }
        if (this.handlerUp != null) {
            this.handlerUp.invalidate();
        }
    }
}

