/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.registries.BloodMagicDamageTypes;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.will.DemonWillHolder;

@RitualRegister(value="lava")
public class RitualLava
extends Ritual {
    public static final String LAVA_RANGE = "lavaRange";
    public static final String FIRE_FUSE_RANGE = "fireFuse";
    public static final String FIRE_RESIST_RANGE = "fireResist";
    public static final String FIRE_DAMAGE_RANGE = "fireDamage";
    public static final String LAVA_TANK_RANGE = "lavaTank";
    public static final double vengefulWillDrain = 1.0;
    public static final double steadfastWillDrain = 0.5;
    public static final double corrosiveWillDrain = 0.2;
    public static final int corrosiveRefreshTime = 20;
    public int timer = 0;

    public RitualLava() {
        super("ritualLava", 0, 10000, "ritual.bloodmagic.lavaRitual");
        this.addBlockRange(LAVA_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(FIRE_FUSE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, -2, -2), 5));
        this.addBlockRange(FIRE_RESIST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(FIRE_DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(LAVA_TANK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(LAVA_RANGE, 9, 3, 3);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_FUSE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_RESIST_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_DAMAGE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(LAVA_TANK_RANGE, 1, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        List entities;
        AreaDescriptor resistRange;
        ++this.timer;
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        int lpDrain = 0;
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double rawDrained = 0.0;
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        AreaDescriptor lavaRange = masterRitualStone.getBlockRange(LAVA_RANGE);
        int maxLavaVolume = this.getMaxVolumeForRange(LAVA_RANGE, willConfig, holder);
        if (!lavaRange.isWithinRange(this.getMaxVerticalRadiusForRange(LAVA_RANGE, willConfig, holder), this.getMaxHorizontalRadiusForRange(LAVA_RANGE, willConfig, holder)) || maxLavaVolume != 0 && lavaRange.getVolume() > maxLavaVolume) {
            return;
        }
        for (BlockPos newPos : lavaRange.getContainedPositions(pos)) {
            BlockState state = world.m_8055_(newPos);
            if (!world.m_46859_(newPos) && !Utils.isFlowingLiquid(world, newPos, state)) continue;
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (currentEssence < lpCost) break;
            world.m_46597_(newPos, Blocks.f_49991_.m_49966_());
            currentEssence -= lpCost;
            lpDrain += lpCost;
            if (!(rawWill > 0.0)) continue;
            double drain = this.getWillCostForRawWill(rawWill);
            rawWill -= drain;
            rawDrained += drain;
        }
        if (rawWill > 0.0) {
            LazyOptional capability;
            AreaDescriptor chestRange = masterRitualStone.getBlockRange(LAVA_TANK_RANGE);
            BlockEntity tile = world.m_7702_(chestRange.getContainedPositions(pos).get(0));
            double drain = this.getWillCostForRawWill(rawWill);
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (rawWill >= drain && currentEssence >= lpCost && tile != null && (capability = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, null)).isPresent()) {
                IFluidHandler handler = (IFluidHandler)capability.resolve().get();
                double filled = handler.fill(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                double ratio = filled / 1000.0;
                rawWill -= drain * ratio;
                rawDrained += drain * ratio;
                currentEssence = (int)((double)currentEssence - Math.ceil((double)lpCost * ratio));
                lpDrain = (int)((double)lpDrain + Math.ceil((double)lpCost * ratio));
            }
        }
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        if (vengefulWill >= 1.0) {
            double vengefulDrained = 0.0;
            AreaDescriptor fuseRange = masterRitualStone.getBlockRange(FIRE_FUSE_RANGE);
            AABB fuseArea = fuseRange.getAABB(pos);
            List entities2 = world.m_45976_(LivingEntity.class, fuseArea);
            for (LivingEntity entity : entities2) {
                if (vengefulWill < 1.0) break;
                if (entity instanceof Player || entity.m_21023_((MobEffect)BloodMagicPotions.FIRE_FUSE.get())) continue;
                entity.m_7292_(new MobEffectInstance((MobEffect)BloodMagicPotions.FIRE_FUSE.get(), 100, 0));
                vengefulDrained += 1.0;
                vengefulWill -= 1.0;
            }
            if (vengefulDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
            }
        }
        if (steadfastWill >= 0.5) {
            double steadfastDrained = 0.0;
            resistRange = masterRitualStone.getBlockRange(FIRE_RESIST_RANGE);
            int duration = this.getFireResistForWill(steadfastWill);
            AABB resistArea = resistRange.getAABB(pos);
            entities = world.m_45976_(Player.class, resistArea);
            for (Player entity : entities) {
                if (steadfastWill < 0.5) break;
                if (entity.m_21023_(MobEffects.f_19607_) && entity.m_21124_(MobEffects.f_19607_).m_19557_() >= 2) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0));
                steadfastDrained += 0.5;
                steadfastWill -= 0.5;
            }
            if (steadfastDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
            }
        }
        if (this.timer % 20 == 0 && corrosiveWill >= 0.2) {
            double corrosiveDrained = 0.0;
            resistRange = masterRitualStone.getBlockRange(FIRE_DAMAGE_RANGE);
            float damage = this.getCorrosiveDamageForWill(corrosiveWill);
            AABB damageArea = resistRange.getAABB(pos);
            entities = world.m_45976_(LivingEntity.class, damageArea);
            for (Player entity : entities) {
                if (corrosiveWill < 0.2) break;
                if (entity.m_6084_() || entity.f_20916_ > 0 || !Utils.isImmuneToFireDamage((LivingEntity)entity) || !entity.m_6469_(entity.m_269291_().m_269079_(BloodMagicDamageTypes.SACRIFICE), damage)) continue;
                corrosiveDrained += 0.2;
                corrosiveWill -= 0.2;
            }
            if (corrosiveDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
            }
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(lpDrain));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 500;
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)(this.getTranslationKey() + ".info")), Component.m_237115_((String)(this.getTranslationKey() + ".default.info")), Component.m_237115_((String)(this.getTranslationKey() + ".corrosive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".steadfast.info")), Component.m_237115_((String)(this.getTranslationKey() + ".destructive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".vengeful.info"))};
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLava();
    }

    @Override
    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return 9 + (int)Math.pow(destructiveWill / 10.0, 1.5);
        }
        return (Integer)this.volumeRangeMap.get(range);
    }

    @Override
    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.verticalRangeMap.get(range);
    }

    @Override
    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.horizontalRangeMap.get(range);
    }

    public int getFireResistForWill(double steadfastWill) {
        return (int)(200.0 + steadfastWill * 3.0);
    }

    public float getCorrosiveDamageForWill(double corrosiveWill) {
        return (float)(1.0 + corrosiveWill * 0.05);
    }

    public int getLPCostForRawWill(double raw) {
        return Math.max((int)(500.0 - raw), 0);
    }

    public double getWillCostForRawWill(double raw) {
        return Math.min(1.0, raw / 500.0);
    }
}

