/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableCuboid;
import wayoftime.bloodmagic.common.item.ItemRitualDiviner;
import wayoftime.bloodmagic.common.item.ItemRitualReader;
import wayoftime.bloodmagic.common.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRitualReaderState;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.will.DemonWillHolder;

@Mod.EventBusSubscriber(modid="bloodmagic", value={Dist.CLIENT})
public class ClientHandler {
    public static final boolean SUPPRESS_ASSET_ERRORS = true;
    public static ResourceLocation ritualStoneBlank = BloodMagic.rl("block/ritualstone");
    public static ResourceLocation ritualStoneWater = BloodMagic.rl("block/waterritualstone");
    public static ResourceLocation ritualStoneFire = BloodMagic.rl("block/fireritualstone");
    public static ResourceLocation ritualStoneEarth = BloodMagic.rl("block/earthritualstone");
    public static ResourceLocation ritualStoneAir = BloodMagic.rl("block/airritualstone");
    public static ResourceLocation ritualStoneDawn = BloodMagic.rl("block/dawnritualstone");
    public static ResourceLocation ritualStoneDusk = BloodMagic.rl("block/duskritualstone");
    public static ResourceLocation boarder = new ResourceLocation("block/chiseled_sandstone");
    public static Minecraft minecraft = Minecraft.m_91087_();
    private static TileMasterRitualStone mrsHoloTile;
    private static TileMasterRitualStone mrsRangeTile;
    private static Ritual mrsHoloRitual;
    private static Direction mrsHoloDirection;
    private static boolean mrsHoloDisplay;
    private static boolean mrsRangeDisplay;
    public static DemonWillHolder currentAura;
    static HashMap<String, ResourceLocation> resourceMap;

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    public static void bindTexture(String path) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientHandler.getResource(path));
    }

    public static void bindAtlas() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        PoseStack stack;
        MultiBufferSource.BufferSource buffers;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        LocalPlayer player = ClientHandler.minecraft.f_91074_;
        Level world = player.m_20193_();
        if (mrsHoloTile != null) {
            if (world.m_7702_(mrsHoloTile.m_58899_()) instanceof TileMasterRitualStone) {
                if (mrsHoloDisplay) {
                    buffers = Minecraft.m_91087_().m_91269_().m_110104_();
                    stack = event.getPoseStack();
                    ClientHandler.renderRitualStones(stack, (MultiBufferSource)buffers, mrsHoloTile, event.getPartialTick());
                    RenderSystem.disableDepthTest();
                    buffers.m_109911_();
                } else {
                    ClientHandler.setRitualHoloToNull();
                }
            } else {
                ClientHandler.setRitualHoloToNull();
            }
        }
        if (mrsRangeTile != null) {
            if (world.m_7702_(mrsRangeTile.m_58899_()) instanceof TileMasterRitualStone) {
                if (mrsRangeDisplay) {
                    buffers = Minecraft.m_91087_().m_91269_().m_110104_();
                    stack = event.getPoseStack();
                    ClientHandler.renderRangeHologram(stack, (MultiBufferSource)buffers, mrsRangeTile, event.getPartialTick());
                    RenderSystem.disableDepthTest();
                    buffers.m_109911_();
                } else {
                    ClientHandler.setRitualRangeHoloToNull();
                }
            } else {
                ClientHandler.setRitualRangeHoloToNull();
            }
        }
        if (ClientHandler.minecraft.f_91077_ == null || ClientHandler.minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(((BlockHitResult)ClientHandler.minecraft.f_91077_).m_82425_());
        if (tileEntity instanceof TileMasterRitualStone && !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof ItemRitualDiviner) {
            MultiBufferSource.BufferSource buffers2 = Minecraft.m_91087_().m_91269_().m_110104_();
            PoseStack stack2 = event.getPoseStack();
            ClientHandler.renderRitualStones(stack2, (MultiBufferSource)buffers2, player, event.getPartialTick());
            RenderSystem.disableDepthTest();
            buffers2.m_109911_();
        }
    }

    private static TextureAtlasSprite forName(TextureAtlas textureMap, String name, String dir) {
        return textureMap.m_118316_(new ResourceLocation("bloodmagic" + dir + "/" + name));
    }

    private static void renderRitualStones(PoseStack stack, MultiBufferSource renderer, LocalPlayer player, float partialTicks) {
        Camera activerenderinfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 eyePos = activerenderinfo.m_90583_();
        VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
        Level world = player.m_20193_();
        ItemRitualDiviner ritualDiviner = (ItemRitualDiviner)player.m_150109_().m_36056_().m_41720_();
        Direction direction = ritualDiviner.getDirection(player.m_150109_().m_36056_());
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(ritualDiviner.getCurrentRitual(player.m_150109_().m_36056_()));
        if (ritual == null) {
            return;
        }
        BlockPos vec3 = ((BlockHitResult)ClientHandler.minecraft.f_91077_).m_82425_();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent ritualComponent : components) {
            stack.m_85836_();
            BlockPos vX = vec3.m_121955_((Vec3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.m_123341_() - eyePos.f_82479_;
            double minY = (double)vX.m_123342_() - eyePos.f_82480_;
            double minZ = (double)vX.m_123343_() - eyePos.f_82481_;
            stack.m_85837_(minX, minY, minZ);
            if (!world.m_8055_(vX).m_60804_((BlockGetter)world, vX)) {
                ResourceLocation rl = null;
                switch (ritualComponent.getRuneType()) {
                    case BLANK: {
                        rl = ritualStoneBlank;
                        break;
                    }
                    case WATER: {
                        rl = ritualStoneWater;
                        break;
                    }
                    case FIRE: {
                        rl = ritualStoneFire;
                        break;
                    }
                    case EARTH: {
                        rl = ritualStoneEarth;
                        break;
                    }
                    case AIR: {
                        rl = ritualStoneAir;
                        break;
                    }
                    case DAWN: {
                        rl = ritualStoneDawn;
                        break;
                    }
                    case DUSK: {
                        rl = ritualStoneDusk;
                    }
                }
                BloodMagicRenderer.Model3D model = ClientHandler.getBlockModel(rl);
                RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -570425345, 0xF000F0, OverlayTexture.f_118083_);
            }
            stack.m_85849_();
        }
    }

    public static void renderRitualStones(PoseStack stack, MultiBufferSource renderer, TileMasterRitualStone masterRitualStone, float partialTicks) {
        Camera activerenderinfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 eyePos = activerenderinfo.m_90583_();
        VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
        LocalPlayer player = ClientHandler.minecraft.f_91074_;
        Level world = player.m_20193_();
        Direction direction = mrsHoloDirection;
        Ritual ritual = mrsHoloRitual;
        if (ritual == null) {
            return;
        }
        BlockPos vec3 = masterRitualStone.m_58899_();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent ritualComponent : components) {
            stack.m_85836_();
            BlockPos vX = vec3.m_121955_((Vec3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.m_123341_() - eyePos.f_82479_;
            double minY = (double)vX.m_123342_() - eyePos.f_82480_;
            double minZ = (double)vX.m_123343_() - eyePos.f_82481_;
            stack.m_85837_(minX, minY, minZ);
            if (!world.m_8055_(vX).m_60804_((BlockGetter)world, vX)) {
                ResourceLocation rl = null;
                switch (ritualComponent.getRuneType()) {
                    case BLANK: {
                        rl = ritualStoneBlank;
                        break;
                    }
                    case WATER: {
                        rl = ritualStoneWater;
                        break;
                    }
                    case FIRE: {
                        rl = ritualStoneFire;
                        break;
                    }
                    case EARTH: {
                        rl = ritualStoneEarth;
                        break;
                    }
                    case AIR: {
                        rl = ritualStoneAir;
                        break;
                    }
                    case DAWN: {
                        rl = ritualStoneDawn;
                        break;
                    }
                    case DUSK: {
                        rl = ritualStoneDusk;
                    }
                }
                BloodMagicRenderer.Model3D model = ClientHandler.getBlockModel(rl);
                RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -570425345, 0xF000F0, OverlayTexture.f_118083_);
            }
            stack.m_85849_();
        }
    }

    public static void renderRangeHologram(PoseStack stack, MultiBufferSource renderer, TileMasterRitualStone masterRitualStone, float partialTicks) {
        ItemStack itemStack;
        EnumRitualReaderState state;
        Camera activerenderinfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 eyePos = activerenderinfo.m_90583_();
        VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
        LocalPlayer player = ClientHandler.minecraft.f_91074_;
        Level world = player.m_20193_();
        if (!player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof ItemRitualReader && (state = ((ItemRitualReader)(itemStack = player.m_21205_()).m_41720_()).getState(itemStack)) == EnumRitualReaderState.SET_AREA) {
            String range = ((ItemRitualReader)itemStack.m_41720_()).getCurrentBlockRange(itemStack);
            AreaDescriptor descriptor = masterRitualStone.getBlockRange(range);
            if (descriptor == null) {
                return;
            }
            stack.m_85836_();
            BlockPos vec3 = masterRitualStone.m_58899_();
            AABB aabb = descriptor.getAABB(vec3);
            double sizeOffset = -0.0625;
            if (aabb.m_82390_(eyePos)) {
                sizeOffset *= -1.0;
            }
            double minX = aabb.f_82288_ - eyePos.f_82479_ + sizeOffset;
            double minY = aabb.f_82289_ - eyePos.f_82480_ + sizeOffset;
            double minZ = aabb.f_82290_ - eyePos.f_82481_ + sizeOffset;
            stack.m_85837_(minX, minY, minZ);
            ResourceLocation rl = boarder;
            BloodMagicRenderer.Model3D model = ClientHandler.getBlockModelWithSize(rl, aabb.m_82362_() - 2.0 * sizeOffset, aabb.m_82376_() - 2.0 * sizeOffset, aabb.m_82385_() - 2.0 * sizeOffset);
            RenderResizableCuboid.INSTANCE.renderCube(model, stack, buffer, -1711324092, 0xF000F0, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
    }

    private static BloodMagicRenderer.Model3D getBlockModel(ResourceLocation rl) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(rl));
        model.minX = 0.0;
        model.minY = 0.0;
        model.minZ = 0.0;
        model.maxX = 1.0;
        model.maxY = 1.0;
        model.maxZ = 1.0;
        return model;
    }

    private static BloodMagicRenderer.Model3D getBlockModelWithSize(ResourceLocation rl, double maxX, double maxY, double maxZ) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(rl));
        model.minX = 0.0;
        model.minY = 0.0;
        model.minZ = 0.0;
        model.maxX = maxX;
        model.maxY = maxY;
        model.maxZ = maxZ;
        return model;
    }

    public static void setRitualHolo(TileMasterRitualStone masterRitualStone, Ritual ritual, Direction direction, boolean displayed) {
        mrsHoloDisplay = displayed;
        mrsHoloTile = masterRitualStone;
        mrsHoloRitual = ritual;
        mrsHoloDirection = direction;
    }

    public static void setRitualHoloToNull() {
        mrsHoloDisplay = false;
        mrsHoloTile = null;
        mrsHoloRitual = null;
        mrsHoloDirection = Direction.NORTH;
    }

    public static void setRitualRangeHolo(TileMasterRitualStone masterRitualStone, boolean displayed) {
        mrsRangeDisplay = displayed;
        mrsRangeTile = masterRitualStone;
    }

    public static void setRitualRangeHoloToNull() {
        mrsRangeDisplay = false;
        mrsRangeTile = null;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(rl);
    }

    public static void handleGuiTank(GuiGraphics guiGraphics, IFluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, ResourceLocation originalTexture, List<Component> tooltip) {
        ClientHandler.handleGuiTank(guiGraphics, tank.getFluid(), tank.getCapacity(), x, y, w, h, oX, oY, oW, oH, mX, mY, originalTexture, tooltip);
    }

    public static void handleGuiTank(GuiGraphics guiGraphics, FluidStack fluid, int capacity, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, ResourceLocation originalTexture, List<Component> tooltip) {
        if (tooltip == null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            if (fluid != null && !fluid.isEmpty()) {
                int fluidHeight = (int)((float)h * ((float)fluid.getAmount() / (float)capacity));
                ClientHandler.drawRepeatedFluidSpriteGui((MultiBufferSource)buffer, guiGraphics, fluid, x, y + h - fluidHeight, w, fluidHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            RenderType renderType = RenderType.m_110466_();
            buffer.m_109912_(renderType);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)originalTexture);
            guiGraphics.m_280163_(originalTexture, x + xOff, y + yOff, (float)oX, (float)oY, oW, oH, 256, 256);
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            ClientHandler.addFluidTooltip(fluid, tooltip, capacity);
        }
    }

    public static void drawRepeatedFluidSpriteGui(MultiBufferSource buffer, GuiGraphics guiGraphics, FluidStack fluid, float x, float y, float w, float h) {
        RenderType renderType = RenderType.m_110466_();
        VertexConsumer builder = buffer.m_6299_(renderType);
        ClientHandler.drawRepeatedFluidSprite(builder, guiGraphics, fluid, x, y, w, h);
    }

    public static void drawRepeatedFluidSprite(VertexConsumer builder, GuiGraphics guiGraphics, FluidStack fluid, float x, float y, float w, float h) {
        TextureAtlasSprite sprite = ClientHandler.getSprite(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
        int col = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
        int iW = sprite.m_245424_().m_246492_();
        int iH = sprite.m_245424_().m_245330_();
        if (iW > 0 && iH > 0) {
            ClientHandler.drawRepeatedSprite(builder, guiGraphics, x, y, w, h, iW, iH, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), (float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f, 1.0f);
        }
    }

    public static void drawRepeatedSprite(VertexConsumer builder, GuiGraphics guiGraphics, float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float alpha) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientHandler.drawTexturedRect(builder, guiGraphics, x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), iconWidth, iconHeight, r, g, b, alpha, uMin, uMax, vMin, vMax);
            }
            ClientHandler.drawTexturedRect(builder, guiGraphics, x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), iconWidth, leftoverH, r, g, b, alpha, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientHandler.drawTexturedRect(builder, guiGraphics, x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, iconHeight, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientHandler.drawTexturedRect(builder, guiGraphics, x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, r, g, b, alpha, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawTexturedRect(VertexConsumer builder, GuiGraphics guiGraphics, float x, float y, float w, float h, float r, float g, float b, float alpha, float u0, float u1, float v0, float v1) {
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        builder.m_252986_(mat, x, y + h, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, x + w, y + h, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, x + w, y, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, x, y, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
    }

    public static void addFluidTooltip(FluidStack fluid, List<Component> tooltip, int tankCapacity) {
        if (!fluid.isEmpty()) {
            tooltip.add((Component)ClientHandler.applyFormat(fluid.getDisplayName(), fluid.getFluid().getFluidType().getRarity((FluidStack)fluid).f_43022_));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"gui.bloodmagic.empty"));
        }
        if (ClientHandler.mc().f_91066_.f_92125_ && !fluid.isEmpty()) {
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.holdShiftForInfo"));
            } else {
                tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)("Fluid Registry: " + ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()))), ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)("Density: " + fluid.getFluid().getFluidType().getDensity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)("Temperature: " + fluid.getFluid().getFluidType().getTemperature(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)("Viscosity: " + fluid.getFluid().getFluidType().getViscosity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)("NBT Data: " + fluid.getTag())), ChatFormatting.DARK_GRAY));
            }
        }
        if (tankCapacity > 0) {
            tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "/" + tankCapacity + "mB")), ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ClientHandler.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "mB")), ChatFormatting.GRAY));
        }
    }

    public static MutableComponent applyFormat(Component component, ChatFormatting ... color) {
        Style style = component.m_7383_();
        for (ChatFormatting format : color) {
            style = style.m_131157_(format);
        }
        return component.m_6881_().m_6270_(style);
    }

    static {
        resourceMap = new HashMap();
    }
}

