/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.client;

import cc.tweaked_programs.cccbridge.client.minecraft.screen.ConfigScreen;
import cc.tweaked_programs.cccbridge.common.modloader.CCCBridge;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CCConfig {
    public static final CCConfig CONFIG = new CCConfig(FMLPaths.CONFIGDIR.get().toString());
    private final Properties properties;
    public String config_dir;
    public boolean FLICKERING;

    public CCConfig(String config_dir) {
        this.config_dir = config_dir + "/cccbridge.properties";
        this.properties = new Properties();
        this.properties.putIfAbsent("flickering", Boolean.toString(true));
        this.load();
    }

    public void load() {
        try (FileReader reader = new FileReader(this.config_dir);){
            this.properties.load(reader);
        }
        catch (FileNotFoundException e) {
            CCCBridge.LOGGER.warn("No config found at '{}'. Creating new one with default values.", (Object)this.config_dir);
            this.save();
        }
        catch (IOException e) {
            CCCBridge.LOGGER.error("Error while loading config at '{}'. Reason: '{}'", (Object)this.config_dir, (Object)e);
        }
        this.FLICKERING = this.properties.get("flickering").toString().equals("true");
    }

    public void save() {
        this.properties.put("flickering", Boolean.toString(this.FLICKERING));
        try (FileWriter writer = new FileWriter(this.config_dir);){
            this.properties.store(writer, "Client side configuration for CC:C Bridge");
        }
        catch (ClassCastException e) {
            CCCBridge.LOGGER.error("Error while casting value for key at config '{}'. Reason: '{}'", (Object)this.config_dir, (Object)e);
        }
        catch (IOException e) {
            CCCBridge.LOGGER.error("Error while saving config at '{}'. Reason: '{}'", (Object)this.config_dir, (Object)e);
        }
    }

    public ConfigScreen newScreen(@Nullable Screen parent) {
        return new ConfigScreen(this, parent);
    }
}

