/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.client.blockEntityRenderer;

import cc.tweaked_programs.cccbridge.client.animatronic.AnimatronicModel;
import cc.tweaked_programs.cccbridge.common.assistance.Randomness;
import cc.tweaked_programs.cccbridge.common.minecraft.block.AnimatronicBlock;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AnimatronicBlockEntityRenderer
implements BlockEntityRenderer<AnimatronicBlockEntity> {
    public static final ResourceLocation TEXTURE_BODY = new ResourceLocation("cccbridge", "textures/entity/animatronic/body.png");
    public static final ResourceLocation TEXTURE_FACE_NORMAL = new ResourceLocation("cccbridge", "textures/entity/animatronic/face_normal.png");
    public static final ResourceLocation TEXTURE_FACE_HAPPY = new ResourceLocation("cccbridge", "textures/entity/animatronic/face_happy.png");
    public static final ResourceLocation TEXTURE_FACE_QUESTION = new ResourceLocation("cccbridge", "textures/entity/animatronic/face_question.png");
    public static final ResourceLocation TEXTURE_FACE_SAD = new ResourceLocation("cccbridge", "textures/entity/animatronic/face_sad.png");
    public static final ResourceLocation TEXTURE_FACE_CURSED = new ResourceLocation("cccbridge", "textures/entity/animatronic/face_creepy.png");
    private static final float scale = 0.875f;
    private final AnimatronicModel<AnimatronicBlockEntity> model = new AnimatronicModel(AnimatronicModel.createBodyLayer().m_171564_());

    public AnimatronicBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull AnimatronicBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85841_(-0.875f, -0.875f, 0.875f);
        poseStack.m_252880_(-0.5666f, -1.5f, 0.5666f);
        this.model.setupAnim(blockEntity, 0.0f, 0.0f, partialTick, 0.0f, 0.0f);
        Level level = blockEntity.m_58904_();
        if (level instanceof VirtualRenderWorld) {
            VirtualRenderWorld virtualRenderWorld = (VirtualRenderWorld)level;
            this.model.hasJob(true);
        } else {
            this.model.hasJob((Boolean)blockEntity.m_58900_().m_61143_((Property)AnimatronicBlock.IS_DRIVER));
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(TEXTURE_BODY));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(Randomness.rareCreepiness() ? TEXTURE_FACE_CURSED : AnimatronicModel.getFace(blockEntity)));
        this.model.m_7695_(poseStack, vertexConsumer, Randomness.lightFlickering(), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(AnimatronicBlockEntity blockEntity) {
        return true;
    }
}

