/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OtterEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> FLOATING = SynchedEntityData.m_135353_(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(OtterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean needsSurface;
    private int huntDelay;
    private int eatDelay;
    private int eatTime;
    private int floatTime;

    public OtterEntity(EntityType<? extends OtterEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new OtterMoveControl(this);
        this.f_21365_ = new OtterLookControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0);
    }

    public static boolean checkOtterSpawnRules(EntityType<OtterEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        return blockPos.m_123342_() > levelAccessor.m_5736_() - 16;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLOATING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 32.0f, 0.9, 1.5, livingEntity -> livingEntity.equals((Object)this.m_21214_())));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new GoToSurfaceGoal(60));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SearchFoodGoal());
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, false, false, fish -> fish instanceof AbstractSchoolingFish && this.getHuntDelay() <= 0));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HuntDelay", this.getHuntDelay());
        compound.m_128379_("Floating", this.isFloating());
        compound.m_128405_("FloatTime", this.floatTime);
        compound.m_128379_("Eating", this.isEating());
        compound.m_128405_("EatTime", this.eatTime);
        compound.m_128405_("EatDelay", this.eatDelay);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.huntDelay = compound.m_128451_("HuntDelay");
        this.setFloating(compound.m_128471_("Floating"));
        this.floatTime = compound.m_128451_("FloatTime");
        this.setEating(compound.m_128471_("Eating"));
        this.eatTime = compound.m_128451_("EatTime");
        this.eatDelay = compound.m_128451_("EatDelay");
    }

    public void m_5993_(Entity killedEntity, int i, DamageSource damageSource) {
        super.m_5993_(killedEntity, i, damageSource);
        if (killedEntity instanceof AbstractSchoolingFish) {
            this.huntDelay = 6000;
        }
    }

    public int m_213860_() {
        return this.f_19796_.m_216339_(3, 7);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_21214_() != null && this.f_19797_ - this.m_21215_() > 100) {
            this.m_21335_(null);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_21515_()) {
            if (this.isFloating()) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                this.m_21567_(0.0f);
                this.m_20301_(this.m_6062_());
                if (--this.floatTime <= 0) {
                    this.setFloating(false);
                }
            }
            if (this.m_5842_() && (this.m_20146_() < 200 || this.f_19796_.m_188501_() <= 0.001f)) {
                this.setNeedsSurface(true);
            }
            if (this.isEating()) {
                if (this.eatDelay > 0) {
                    --this.eatDelay;
                } else {
                    Vec3 mouthPos = this.calculateMouthPos();
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_21205_()), mouthPos.m_7096_(), mouthPos.m_7098_(), mouthPos.m_7094_(), 2, 0.0, 0.1, 0.0, 0.05);
                    if (this.m_217043_().m_188500_() < 0.5) {
                        this.m_5496_((SoundEvent)CACSounds.OTTER_EAT.get(), 1.2f, 1.0f);
                    }
                    if (--this.eatTime <= 0) {
                        this.m_5584_(this.m_9236_(), this.m_21205_());
                        this.setEating(false);
                    }
                }
            } else if (this.m_6898_(this.m_21205_())) {
                if (this.m_20069_()) {
                    if (this.isFloating()) {
                        this.startEating();
                    } else {
                        this.setNeedsSurface(true);
                    }
                } else if (this.m_20096_()) {
                    this.startEating();
                }
            }
            if (this.huntDelay > 0) {
                --this.huntDelay;
            }
        }
    }

    public ItemStack m_5584_(Level level, ItemStack itemStack) {
        if (itemStack.m_150930_((Item)CACItems.CLAM.get())) {
            if (this.f_19796_.m_188501_() <= 0.07f) {
                Vec3 mouthPos = this.calculateMouthPos();
                ItemEntity pearl = new ItemEntity(level, mouthPos.m_7096_(), mouthPos.m_7098_(), mouthPos.m_7094_(), new ItemStack((ItemLike)CACItems.PEARL.get()));
                pearl.m_20334_(this.m_217043_().m_188583_() * 0.05, this.m_217043_().m_188583_() * 0.05 + 0.2, this.m_217043_().m_188583_() * 0.05);
                level.m_7967_((Entity)pearl);
            }
            level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12533_, SoundSource.NEUTRAL, 0.8f, 1.5f);
            itemStack.m_41774_(1);
            return itemStack;
        }
        return super.m_5584_(level, itemStack);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.6f : 1.0f;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        if (this.rejectedItem(itemEntity)) {
            return;
        }
        ItemStack itemsEquipped = this.m_255207_(itemStack);
        if (!itemsEquipped.m_41619_()) {
            int count = itemsEquipped.m_41613_();
            if (count > 1) {
                ItemStack leftover = itemStack.m_41777_();
                leftover.m_41774_(itemsEquipped.m_41613_());
                ItemEntity extraItems = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), leftover);
                this.m_9236_().m_7967_((Entity)extraItems);
            }
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, itemsEquipped.m_41613_());
            itemEntity.m_146870_();
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new OtterPathNavigation(this, level);
    }

    public int m_6062_() {
        return 9600;
    }

    protected void m_203347_(TagKey<Fluid> fluidTag) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.08f * this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), 0.0));
    }

    public void m_7023_(Vec3 speed) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), speed);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            this.m_267651_(false);
        } else {
            super.m_7023_(speed);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack handStack = player.m_21120_(interactionHand);
        if (!this.isEating() && this.m_6898_(handStack)) {
            this.m_21008_(InteractionHand.MAIN_HAND, handStack.m_41620_(1));
            handStack.m_41774_(1);
            return super.m_6071_(player, interactionHand);
        }
        return InteractionResult.PASS;
    }

    public boolean m_7252_(ItemStack itemStack) {
        return this.m_6898_(itemStack) && this.isHungryAt(itemStack);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41614_() && stack.m_204117_(ItemTags.f_13156_) || stack.m_150930_((Item)CACItems.CLAM.get());
    }

    public boolean m_35506_() {
        return !this.m_6162_();
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        OtterEntity otter = (OtterEntity)((EntityType)CACEntities.OTTER.get()).m_20615_((Level)level);
        return otter;
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            this.m_5496_((SoundEvent)CACSounds.BITE_ATTACK.get(), this.m_6121_(), this.m_6100_());
            return true;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CACSounds.OTTER_AMBIENT.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)CACSounds.OTTER_SWIM.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CACSounds.OTTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CACSounds.OTTER_DEATH.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, p_146750_);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && this.f_19796_.m_188501_() <= 0.2f) {
            for (int i = 0; i < this.f_19796_.m_216339_(1, 4); ++i) {
                OtterEntity baby = (OtterEntity)((EntityType)CACEntities.OTTER.get()).m_20615_(this.m_9236_());
                baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                baby.m_6863_(true);
                levelAccessor.m_7967_((Entity)baby);
            }
        }
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.m_20069_()) {
            if (this.isFloating()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("otter_float"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("otter_swim"));
            }
            return PlayState.CONTINUE;
        }
        if (this.isEating()) {
            if (this.m_21205_().m_150930_((Item)CACItems.CLAM.get())) {
                event.getController().setAnimation(RawAnimation.begin().then("otter_open", Animation.LoopType.PLAY_ONCE));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("otter_standing_eat", Animation.LoopType.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("otter_walk"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().thenLoop("otter_idle"));
        return PlayState.CONTINUE;
    }

    private PlayState floatingHandsPredicate(AnimationState<?> event) {
        if (this.isFloating()) {
            if (this.isEating() && this.eatDelay <= 0) {
                event.getController().setAnimation(RawAnimation.begin().then("otter_hands_float_eat", Animation.LoopType.PLAY_ONCE));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("otter_hands_float_idle"));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "floating_hands_controller", 10, this::floatingHandsPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isHungryAt(ItemStack foodStack) {
        return foodStack.m_150930_((Item)CACItems.CLAM.get()) || this.m_27591_() <= 0;
    }

    private void rejectFood() {
        if (!this.m_21205_().m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21205_().m_41777_());
            itemEntity.m_32010_(40);
            itemEntity.m_32052_(this.m_20148_());
            this.m_21205_().m_41774_(1);
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    public boolean rejectedItem(ItemEntity itemEntity) {
        if (itemEntity.m_19749_() != null) {
            return itemEntity.m_19749_().equals((Object)this.m_20148_());
        }
        return false;
    }

    private void startEating() {
        if (this.m_6898_(this.m_21205_())) {
            this.eatDelay = this.m_21205_().m_150930_((Item)CACItems.CLAM.get()) ? 35 : 12;
            this.eatTime = 20;
            this.setEating(true);
        }
    }

    private void startFloating(int time) {
        this.floatTime = time;
        this.setFloating(true);
    }

    public Vec3 calculateMouthPos() {
        Vec3 viewVector = this.m_20252_(0.0f).m_82490_(this.isFloating() ? 0.3 : 0.6).m_82520_(0.0, this.isFloating() ? 0.55 : 0.0, 0.0).m_82490_((double)this.m_6134_());
        return new Vec3(this.m_20185_() + viewVector.m_7096_(), this.m_20186_() + viewVector.m_7098_(), this.m_20189_() + viewVector.m_7094_());
    }

    public int getHuntDelay() {
        return this.huntDelay;
    }

    public boolean needsSurface() {
        return this.needsSurface;
    }

    public void setNeedsSurface(boolean needsSurface) {
        this.needsSurface = needsSurface;
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public boolean isFloating() {
        return (Boolean)this.f_19804_.m_135370_(FLOATING);
    }

    public void setFloating(boolean floating) {
        this.f_19804_.m_135381_(FLOATING, (Object)floating);
    }

    static class OtterMoveControl
    extends MoveControl {
        private final OtterEntity otter;

        public OtterMoveControl(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public void m_8126_() {
            if (this.otter.m_20069_()) {
                if (!this.otter.needsSurface()) {
                    this.otter.m_20256_(this.otter.m_20184_().m_82549_(this.otter.m_20154_().m_82490_(this.otter.isFloating() ? (double)0.002f : (double)0.005f)));
                }
                if (!this.otter.isFloating()) {
                    if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                        double d2;
                        double d1;
                        double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                        double distanceSqr = d0 * d0 + (d1 = this.f_24976_ - this.f_24974_.m_20186_()) * d1 + (d2 = this.f_24977_ - this.f_24974_.m_20189_()) * d2;
                        if (distanceSqr < 2.500000277905201E-7) {
                            this.f_24974_.m_21564_(0.0f);
                        } else {
                            float yRot = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), yRot, 40.0f));
                            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                            float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                            this.f_24974_.m_7910_(speed * 0.2f);
                            double horizontalDistance = Math.sqrt(d0 * d0 + d2 * d2);
                            if (Math.abs(d1) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                                float xRot = -((float)(Mth.m_14136_((double)d1, (double)horizontalDistance) * 57.2957763671875));
                                xRot = Mth.m_14036_((float)Mth.m_14177_((float)xRot), (float)-180.0f, (float)180.0f);
                                this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), xRot, 45.0f));
                            }
                            BlockPos wantedPos = BlockPos.m_274561_((double)this.f_24975_, (double)this.f_24976_, (double)this.f_24977_);
                            BlockState wantedBlockState = this.f_24974_.m_9236_().m_8055_(wantedPos);
                            if (d1 > (double)this.f_24974_.m_274421_() && d0 * d0 + d2 * d2 < 4.0 && d1 <= 1.0 && wantedBlockState.m_60819_().m_76178_()) {
                                this.f_24974_.m_21569_().m_24901_();
                                this.f_24974_.m_7910_(speed);
                            }
                            float f0 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                            float f1 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                            this.f_24974_.f_20902_ = f0 * speed;
                            this.f_24974_.f_20901_ = -f1 * speed;
                        }
                    } else {
                        this.f_24974_.m_7910_(0.0f);
                        this.f_24974_.m_21570_(0.0f);
                        this.f_24974_.m_21567_(0.0f);
                        this.f_24974_.m_21564_(0.0f);
                    }
                }
            } else {
                super.m_8126_();
            }
        }
    }

    static class OtterLookControl
    extends LookControl {
        private final OtterEntity otter;

        public OtterLookControl(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public void m_8128_() {
            if (this.otter.m_20069_()) {
                if (this.f_186068_ > 0) {
                    --this.f_186068_;
                    this.m_180896_().ifPresent(p_181134_ -> {
                        this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, p_181134_.floatValue() + 20.0f, this.f_24938_);
                    });
                    this.m_180897_().ifPresent(p_181132_ -> this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), p_181132_.floatValue() + 10.0f, this.f_24939_)));
                } else {
                    if (this.f_24937_.m_21573_().m_26571_()) {
                        this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 5.0f));
                    }
                    this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, this.f_24938_);
                }
            } else {
                super.m_8128_();
            }
        }
    }

    public class GoToSurfaceGoal
    extends Goal {
        private final int timeoutTime;
        private boolean goingLand;
        private Vec3 targetPos;
        private int timeoutTimer;

        public GoToSurfaceGoal(int timeoutTime) {
            this.timeoutTime = timeoutTime;
            this.timeoutTimer = timeoutTime;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return OtterEntity.this.m_6084_() && OtterEntity.this.needsSurface() && !OtterEntity.this.m_20096_();
        }

        public void m_8056_() {
            if (OtterEntity.this.m_21205_().m_150930_((Item)CACItems.CLAM.get())) {
                this.targetPos = LandRandomPos.m_148488_((PathfinderMob)OtterEntity.this, (int)7, (int)15);
                this.goingLand = true;
            } else {
                this.targetPos = this.findAirPosition();
                this.goingLand = false;
            }
        }

        public void m_8037_() {
            if (this.targetPos == null || !OtterEntity.this.m_9236_().m_8055_(BlockPos.m_274446_((Position)this.targetPos)).m_60795_()) {
                if (OtterEntity.this.m_21205_().m_150930_((Item)CACItems.CLAM.get())) {
                    this.targetPos = LandRandomPos.m_148488_((PathfinderMob)OtterEntity.this, (int)15, (int)7);
                    this.goingLand = true;
                } else {
                    this.targetPos = this.findAirPosition();
                    this.goingLand = false;
                }
                this.tickTimeout();
            } else {
                OtterEntity.this.m_21573_().m_26519_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_(), 1.0);
                OtterEntity.this.m_19920_(0.02f, new Vec3((double)OtterEntity.this.f_20900_, (double)OtterEntity.this.f_20901_, (double)OtterEntity.this.f_20902_));
                OtterEntity.this.m_6478_(MoverType.SELF, OtterEntity.this.m_20184_());
                if (this.goingLand) {
                    if (!OtterEntity.this.m_20069_() && OtterEntity.this.m_20096_()) {
                        this.m_8041_();
                    }
                } else {
                    double d0;
                    if (this.targetPos.m_7098_() > OtterEntity.this.m_20186_() && this.targetPos.m_82557_(OtterEntity.this.m_20182_()) <= 3.0) {
                        OtterEntity.this.m_5997_(0.0, 0.02, 0.0);
                    }
                    if (Math.sqrt((d0 = this.targetPos.m_7098_() - OtterEntity.this.m_146892_().m_7098_()) * d0) <= 0.1) {
                        OtterEntity.this.m_20256_(OtterEntity.this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                        OtterEntity.this.m_21567_(0.0f);
                        OtterEntity.this.m_7910_(0.0f);
                        OtterEntity.this.startFloating(OtterEntity.this.m_217043_().m_216339_(80, 201));
                        this.m_8041_();
                    }
                }
            }
        }

        public void tickTimeout() {
            if (this.timeoutTimer % 2 == 0) {
                ((ServerLevel)OtterEntity.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123795_, OtterEntity.this.m_20208_(0.6), OtterEntity.this.m_20186_(), OtterEntity.this.m_20262_(0.6), 2, 0.0, 0.1, 0.0, 0.0);
            }
            if (this.timeoutTimer <= 0) {
                OtterEntity.this.m_5496_((SoundEvent)CACSounds.OTTER_AMBIENT.get(), OtterEntity.this.m_6121_(), 0.3f);
                OtterEntity.this.rejectFood();
                this.m_8041_();
            }
            --this.timeoutTimer;
        }

        public void m_8041_() {
            OtterEntity.this.setNeedsSurface(false);
            OtterEntity.this.m_21573_().m_26573_();
            this.timeoutTimer = this.timeoutTime;
        }

        private Vec3 findAirPosition() {
            Iterable blocksInRadius = BlockPos.m_121976_((int)Mth.m_14107_((double)(OtterEntity.this.m_20185_() - 1.0)), (int)OtterEntity.this.m_146904_(), (int)Mth.m_14107_((double)(OtterEntity.this.m_20189_() - 1.0)), (int)Mth.m_14107_((double)(OtterEntity.this.m_20185_() + 1.0)), (int)Mth.m_14107_((double)(OtterEntity.this.m_20186_() + 16.0)), (int)Mth.m_14107_((double)(OtterEntity.this.m_20189_() + 1.0)));
            BlockPos airPos = null;
            for (BlockPos blockPos : blocksInRadius) {
                if (!OtterEntity.this.m_9236_().m_8055_(blockPos).m_60795_()) continue;
                airPos = blockPos;
                break;
            }
            return airPos != null ? Vec3.m_82539_(airPos) : null;
        }
    }

    static class BreedGoal
    extends net.minecraft.world.entity.ai.goal.BreedGoal {
        private final OtterEntity otter;

        public BreedGoal(OtterEntity otterEntity) {
            super((Animal)otterEntity, 1.0);
            this.otter = otterEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.otter.isEating();
        }
    }

    public class SearchFoodGoal
    extends Goal {
        public SearchFoodGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!OtterEntity.this.m_21205_().m_41619_()) {
                return false;
            }
            List itemsInRadius = OtterEntity.this.m_9236_().m_6443_(ItemEntity.class, OtterEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.m_7243_(itemEntity.m_32055_()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            return !itemsInRadius.isEmpty();
        }

        public void m_8037_() {
            List itemsInRadius = OtterEntity.this.m_9236_().m_6443_(ItemEntity.class, OtterEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.m_7243_(itemEntity.m_32055_()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            ItemStack handStack = OtterEntity.this.m_21205_();
            if (handStack.m_41619_() && !itemsInRadius.isEmpty()) {
                Path path = OtterEntity.this.m_21573_().m_6570_((Entity)itemsInRadius.get(0), 0);
                OtterEntity.this.m_21573_().m_26536_(path, 1.0);
            }
        }

        public void m_8056_() {
            List itemsInRadius = OtterEntity.this.m_9236_().m_6443_(ItemEntity.class, OtterEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), itemEntity -> OtterEntity.this.m_7243_(itemEntity.m_32055_()) && !OtterEntity.this.rejectedItem((ItemEntity)itemEntity));
            if (!itemsInRadius.isEmpty()) {
                Path path = OtterEntity.this.m_21573_().m_6570_((Entity)itemsInRadius.get(0), 0);
                OtterEntity.this.m_21573_().m_26536_(path, 1.0);
            }
        }
    }

    static class FollowParentGoal
    extends net.minecraft.world.entity.ai.goal.FollowParentGoal {
        private final OtterEntity otter;

        public FollowParentGoal(OtterEntity otterEntity) {
            super((Animal)otterEntity, 1.2);
            this.otter = otterEntity;
        }

        public boolean m_8036_() {
            return !this.otter.isEating() && super.m_8036_();
        }
    }

    static class RandomStrollGoal
    extends net.minecraft.world.entity.ai.goal.RandomStrollGoal {
        private final OtterEntity otter;

        public RandomStrollGoal(OtterEntity otterEntity) {
            super((PathfinderMob)otterEntity, 1.0, 20);
            this.otter = otterEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.otter.isFloating() && !this.otter.needsSurface() && !this.otter.isEating();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.otter.isFloating() && !this.otter.needsSurface() && !this.otter.isEating();
        }
    }

    static class LookAtPlayerGoal
    extends net.minecraft.world.entity.ai.goal.LookAtPlayerGoal {
        private final OtterEntity otter;

        public LookAtPlayerGoal(OtterEntity otterEntity) {
            super((Mob)otterEntity, Player.class, 8.0f);
            this.otter = otterEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.otter.m_20069_() && !this.otter.isEating();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.otter.m_20069_() && !this.otter.isEating();
        }
    }

    static class RandomLookAroundGoal
    extends net.minecraft.world.entity.ai.goal.RandomLookAroundGoal {
        private final OtterEntity otter;

        public RandomLookAroundGoal(OtterEntity otterEntity) {
            super((Mob)otterEntity);
            this.otter = otterEntity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.otter.m_20069_() && !this.otter.isEating();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.otter.m_20069_() && !this.otter.isEating();
        }
    }

    static class OtterPathNavigation
    extends WaterBoundPathNavigation {
        private final OtterEntity otter;

        public OtterPathNavigation(OtterEntity otterEntity, Level level) {
            super((Mob)otterEntity, level);
            this.otter = otterEntity;
        }

        protected PathFinder m_5532_(int p_26531_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, p_26531_);
        }

        protected Vec3 m_7475_() {
            return new Vec3(this.otter.m_20185_(), this.otter.m_20227_(0.5), this.otter.m_20189_());
        }

        protected boolean m_7632_() {
            return true;
        }

        public boolean m_6342_(BlockPos destination) {
            if (this.otter.m_20069_() && this.f_26495_.m_8055_(destination).m_60795_()) {
                return !this.f_26495_.m_8055_(destination.m_7495_()).m_60795_() && !this.f_26495_.m_8055_(destination.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_);
            }
            return !this.f_26495_.m_8055_(destination.m_7495_()).m_60795_();
        }
    }
}

