/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SeaBunnyEntity
extends WaterAnimal
implements Bucketable,
GeoEntity {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected int harvestCooldown;

    public SeaBunnyEntity(EntityType<? extends SeaBunnyEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SeaBunnyMoveControl(this);
        this.f_21343_ = new SeaBunnyJumpControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.08);
    }

    public static boolean checkSeaBunnySpawnRules(EntityType<SeaBunnyEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        return blockPos.m_123342_() < levelAccessor.m_5736_() - 8;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double distance) {
        return !this.m_27487_() && !this.m_8077_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RandomStrollGoal(this, 1.0));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Climbing", this.isClimbing());
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setClimbing(compound.m_128471_("Climbing"));
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public int m_213860_() {
        return this.f_19796_.m_216339_(2, 5);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.harvestCooldown > 0) {
            --this.harvestCooldown;
        }
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack bucketStack) {
        CompoundTag bucketCompound = bucketStack.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucketStack);
        bucketCompound.m_128405_("BucketVariant", this.getVariant());
    }

    public void m_142278_(CompoundTag bucketCompound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)bucketCompound);
        if (bucketCompound.m_128441_("BucketVariant")) {
            this.setVariant(bucketCompound.m_128451_("BucketVariant"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)CACItems.SEA_BUNNY_BUCKET.get());
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CACSounds.SEA_BUNNY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CACSounds.SEA_BUNNY_DEATH.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag bucketCompound) {
        if (!mobSpawnType.equals((Object)MobSpawnType.BUCKET) || bucketCompound == null || !bucketCompound.m_128441_("BucketVariant")) {
            this.setVariant(this.f_19796_.m_216339_(0, 3));
        }
        return super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, bucketCompound);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setClimbing(this.f_19862_ && this.m_21573_().m_26572_());
        }
    }

    public float m_21692_(BlockPos blockPos) {
        return this.m_9236_().m_8055_(blockPos).m_60819_().m_76178_() ? 1.0f : 5.0f;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7023_(Vec3 speed) {
        super.m_7023_(speed);
        if (this.f_19862_ && this.m_6147_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.12, 0.0));
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack handStack = player.m_21120_(interactionHand);
        if (handStack.m_150930_(Items.f_42446_) || handStack.m_150930_(Items.f_42447_)) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
        }
        if (handStack.m_150930_(Items.f_42590_) && this.harvestCooldown <= 0) {
            handStack.m_41774_(1);
            this.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.8f);
            if (handStack.m_41619_()) {
                player.m_21008_(interactionHand, new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()))) {
                player.m_36176_(new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()), false);
            }
            this.harvestCooldown = 6000;
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, interactionHand);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.m_6113_() > 0.03f) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sea_bunny_move"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sea_bunny"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)2));
    }

    static class SeaBunnyMoveControl
    extends MoveControl {
        public SeaBunnyMoveControl(SeaBunnyEntity seaBunny) {
            super((Mob)seaBunny);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 90.0f));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                float speed = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
                speed = (float)((double)speed * (this.f_24974_.m_20069_() ? 2.0 + this.f_24978_ : this.f_24978_));
                this.f_24974_.m_7910_(speed);
            } else {
                this.f_24974_.m_7910_(0.0f);
            }
        }
    }

    static class SeaBunnyJumpControl
    extends JumpControl {
        public SeaBunnyJumpControl(SeaBunnyEntity seaBunny) {
            super((Mob)seaBunny);
        }

        public void m_24901_() {
        }
    }

    static class RandomStrollGoal
    extends net.minecraft.world.entity.ai.goal.RandomStrollGoal {
        public RandomStrollGoal(SeaBunnyEntity seaBunny, double speedModifier) {
            super((PathfinderMob)seaBunny, speedModifier, 20);
        }

        protected Vec3 m_7037_() {
            Vec3 randomPos = RandomPos.m_148542_((PathfinderMob)this.f_25725_, () -> {
                BlockPos dirPos = RandomPos.m_217851_((RandomSource)this.f_25725_.m_217043_(), (int)2, (int)2);
                BlockPos dirRandomPos = RandomPos.m_217863_((PathfinderMob)this.f_25725_, (int)2, (RandomSource)this.f_25725_.m_217043_(), (BlockPos)dirPos);
                BlockPos finalPos = RandomPos.m_148545_((BlockPos)dirRandomPos, (int)this.f_25725_.m_9236_().m_151558_(), blockPos -> GoalUtils.m_148461_((PathfinderMob)this.f_25725_, (BlockPos)blockPos));
                return this.f_25725_.m_9236_().m_8055_(finalPos).m_60819_().m_76178_() ? null : finalPos;
            });
            return randomPos;
        }
    }
}

