/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.entity.DragonflyEntity;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.LeafInsectEntity;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crittersandcompanions")
public class SpawnHandler {
    @SubscribeEvent
    public static void onLivingCheckSpawn(MobSpawnEvent.PositionCheck event) {
        Mob mob = event.getEntity();
        if (mob instanceof Drowned) {
            Drowned drowned = (Drowned)mob;
            if (event.getSpawnType() == MobSpawnType.NATURAL && drowned.m_217043_().m_188501_() <= 0.05f) {
                drowned.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)CACItems.CLAM.get()));
            }
        }
    }

    public static void datagenBiomeModifiers(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
    }

    @SafeVarargs
    public static HolderSet<Biome> getBiomeHolderSet(Registry<Biome> registry, ResourceKey<Biome> ... biomes) {
        return HolderSet.m_205800_(Arrays.stream(biomes).map(arg_0 -> registry.m_246971_(arg_0)).toList());
    }

    public static BiomeModifier createSpawnModifier(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData ... spawnerData) {
        return spawnerData.length == 1 ? ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn(biomes, (MobSpawnSettings.SpawnerData)spawnerData[0]) : new ForgeBiomeModifiers.AddSpawnsBiomeModifier(biomes, Arrays.stream(spawnerData).toList());
    }

    public static void registerSpawnPlacements() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.OTTER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OtterEntity::checkOtterSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.KOI_FISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.DRAGONFLY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, DragonflyEntity::checkDragonflySpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.SEA_BUNNY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.create((String)"ON_WATER_GROUND", (levelReader, blockPos, entityType) -> levelReader.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && levelReader.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)levelReader, blockPos.m_7495_(), Direction.UP)), (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, SeaBunnyEntity::checkSeaBunnySpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.FERRET.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.DUMBO_OCTOPUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DumboOctopusEntity::checkDumboOctopusSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.LEAF_INSECT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, LeafInsectEntity::checkLeafInsectSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.RED_PANDA.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_);
    }
}

