/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import com.github.eterdelta.crittersandcompanions.capability.ISilkLeashStateCapability;
import com.github.eterdelta.crittersandcompanions.entity.ILeashStateEntity;
import com.github.eterdelta.crittersandcompanions.item.PearlNecklaceItem;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ILeashStateEntity {
    @Unique
    private final Pair<Set<UUID>, Set<UUID>> savedLeashState = new ObjectObjectImmutablePair(new HashSet(), new HashSet());
    @Unique
    private LazyOptional<ISilkLeashStateCapability> leashStateCache;
    @Unique
    private boolean needsLeashStateLoad;
    @Unique
    private int leashStateLoadDelay;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void onAddAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            this.getLeashStateCache().ifPresent(state -> {
                ListTag leashingEntitiesList = new ListTag();
                for (Entity entity : state.getLeashingEntities()) {
                    leashingEntitiesList.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
                }
                compoundTag.m_128365_("LeashingEntities", (Tag)leashingEntitiesList);
                ListTag leashedByEntitiesList = new ListTag();
                for (Entity entity : state.getLeashedByEntities()) {
                    leashedByEntitiesList.add((Object)NbtUtils.m_129226_((UUID)entity.m_20148_()));
                }
                compoundTag.m_128365_("LeashedByEntities", (Tag)leashedByEntitiesList);
            });
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void onReadAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            this.getLeashStateCache().ifPresent(state -> {
                ListTag leashingEntitiesList = compoundTag.m_128437_("LeashingEntities", 11);
                for (Tag tag : leashingEntitiesList) {
                    UUID uuid = NbtUtils.m_129233_((Tag)tag);
                    ((Set)this.savedLeashState.first()).add(uuid);
                }
                ListTag leashedByEntitiesList = compoundTag.m_128437_("LeashedByEntities", 11);
                for (Tag tag : leashedByEntitiesList) {
                    UUID uuid = NbtUtils.m_129233_((Tag)tag);
                    ((Set)this.savedLeashState.second()).add(uuid);
                }
                if (!leashingEntitiesList.isEmpty() || !leashedByEntitiesList.isEmpty()) {
                    this.needsLeashStateLoad = true;
                }
            });
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onTick(CallbackInfo callbackInfo) {
        if (!this.m_9236_().m_5776_()) {
            this.getLeashStateCache().ifPresent(leashState -> {
                if (this.needsLeashStateLoad) {
                    ++this.leashStateLoadDelay;
                    if (this.leashStateLoadDelay >= 20) {
                        LivingEntity entity;
                        Set<LivingEntity> leashingEntities = leashState.getLeashingEntities();
                        Set<LivingEntity> leashedByEntities = leashState.getLeashedByEntities();
                        for (UUID uuid : (Set)this.savedLeashState.first()) {
                            entity = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(uuid);
                            if (entity == null) continue;
                            leashingEntities.add(entity);
                        }
                        ((Set)this.savedLeashState.first()).clear();
                        for (UUID uuid : (Set)this.savedLeashState.second()) {
                            entity = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(uuid);
                            if (entity == null) continue;
                            leashedByEntities.add(entity);
                        }
                        ((Set)this.savedLeashState.second()).clear();
                        this.sendLeashState();
                        this.needsLeashStateLoad = false;
                        this.leashStateLoadDelay = 0;
                    }
                }
                int unleashedEntities = 0;
                Iterator<LivingEntity> iterator = leashState.getLeashingEntities().iterator();
                while (iterator.hasNext()) {
                    LivingEntity leashedEntity = iterator.next();
                    Vec3 distance = this.m_20182_().m_82546_(leashedEntity.m_20182_());
                    double distanceSqr = distance.m_82556_();
                    if (!(distanceSqr > 14.0)) continue;
                    leashedEntity.m_20256_(leashedEntity.m_20184_().m_82549_(distance.m_82490_(0.1).m_82520_(0.0, 0.1, 0.0)));
                    if (!(distanceSqr > 28.0)) continue;
                    ILeashStateEntity leashedStateEntity = (ILeashStateEntity)leashedEntity;
                    leashedStateEntity.getLeashStateCache().ifPresent(leashedLeashState -> {
                        leashedLeashState.getLeashedByEntities().remove(this);
                        leashedStateEntity.sendLeashState();
                    });
                    iterator.remove();
                    ++unleashedEntities;
                }
                if (unleashedEntities > 0) {
                    ItemEntity leadEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedEntities));
                    this.m_9236_().m_7967_((Entity)leadEntity);
                    this.sendLeashState();
                }
            });
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.gameEvent(Lnet/minecraft/world/level/gameevent/GameEvent;)V", ordinal=0, shift=At.Shift.BY, by=1)}, method={"die"})
    private void onDie(DamageSource source, CallbackInfo callbackInfo) {
        this.getLeashStateCache().ifPresent(state -> {
            int unleashedStates = 0;
            unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates((LivingEntity)this, null) - 1);
            if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, (LivingEntity)this) - 1)) > 0) {
                ItemEntity leadEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedStates));
                this.m_9236_().m_7967_((Entity)leadEntity);
            }
        });
    }

    @Redirect(at=@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.isInWater()Z"), method={"travel(Lnet/minecraft/world/phys/Vec3;)V"})
    private boolean redirectIsInWater(LivingEntity entity) {
        return this.m_20069_() || this.m_146900_().m_60713_((Block)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyVariable(at=@At(value="LOAD"), method={"aiStep()V"}, ordinal=0)
    private boolean modifyWaterFlag(boolean flag) {
        return flag || this.m_146900_().m_60713_((Block)CACBlocks.SEA_BUNNY_SLIME_BLOCK.get());
    }

    @ModifyVariable(at=@At(value="LOAD", ordinal=3), method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, ordinal=1)
    private float modifySwimSpeed(float swimSpeed) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                Item item = stack.m_41720_();
                if (!(item instanceof PearlNecklaceItem)) continue;
                PearlNecklaceItem pearlNecklaceItem = (PearlNecklaceItem)item;
                return swimSpeed + swimSpeed * ((float)(pearlNecklaceItem.getLevel() * 20) / 100.0f);
            }
        }
        return swimSpeed;
    }

    @Override
    public LazyOptional<ISilkLeashStateCapability> getLeashStateCache() {
        LazyOptional cache = this.leashStateCache;
        if (cache == null) {
            cache = this.leashStateCache = this.getCapability(CACCapabilities.SILK_LEASH_STATE);
            cache.addListener(self -> {
                this.leashStateCache = null;
            });
        }
        return cache;
    }

    @Override
    public void sendLeashState() {
        this.getLeashStateCache().ifPresent(leashState -> CACPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(this.m_19879_(), (IntList)new IntArrayList(leashState.getLeashingEntities().stream().mapToInt(Entity::m_19879_).toArray()), (IntList)new IntArrayList(leashState.getLeashedByEntities().stream().mapToInt(Entity::m_19879_).toArray())))));
    }
}

