/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.network;

import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSilkLeashStatePacket {
    private final List<LeashData> leashDataList;

    public ClientboundSilkLeashStatePacket(List<LeashData> leashDataList) {
        this.leashDataList = leashDataList;
    }

    public ClientboundSilkLeashStatePacket(LeashData ... leashData) {
        this(Arrays.asList(leashData));
    }

    public ClientboundSilkLeashStatePacket(FriendlyByteBuf byteBuf) {
        int size = byteBuf.readInt();
        this.leashDataList = new ArrayList<LeashData>(size);
        for (int i = 0; i < size; ++i) {
            int leashOwner = byteBuf.readInt();
            IntList leashingEntities = byteBuf.m_178338_();
            IntList leashedByEntities = byteBuf.m_178338_();
            this.leashDataList.add(new LeashData(leashOwner, leashingEntities, leashedByEntities));
        }
    }

    public void write(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.leashDataList.size());
        for (LeashData data : this.leashDataList) {
            byteBuf.writeInt(data.leashOwner);
            byteBuf.m_178345_(data.leashingEntities);
            byteBuf.m_178345_(data.leashedByEntities);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            for (LeashData data : this.leashDataList) {
                Entity entity = level.m_6815_(data.leashOwner());
                if (entity == null) continue;
                LazyOptional capability = entity.getCapability(CACCapabilities.SILK_LEASH_STATE);
                capability.ifPresent(leashState -> {
                    leashState.getLeashingEntities().clear();
                    leashState.getLeashedByEntities().clear();
                    data.leashingEntities().forEach(id -> {
                        Entity leashingEntity = level.m_6815_(id);
                        if (leashingEntity instanceof LivingEntity) {
                            leashState.getLeashingEntities().add((LivingEntity)leashingEntity);
                        }
                    });
                    data.leashedByEntities().forEach(id -> {
                        Entity leashedByEntity = level.m_6815_(id);
                        if (leashedByEntity instanceof LivingEntity) {
                            leashState.getLeashedByEntities().add((LivingEntity)leashedByEntity);
                        }
                    });
                });
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public record LeashData(int leashOwner, IntList leashingEntities, IntList leashedByEntities) {
    }
}

