/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.BufferBuilderPool;

public class BatchableBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final BufferBuilder FALLBACK_BUFFER = new BufferBuilder(0);
    protected final Reference2ObjectMap<RenderType, ReferenceSet<BufferBuilder>> fallbackBuffers = new Reference2ObjectLinkedOpenHashMap();
    protected final ReferenceSet<RenderType> activeLayers = new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public BatchableBufferSource() {
        this((Map<RenderType, BufferBuilder>)ImmutableMap.of());
    }

    public BatchableBufferSource(Map<RenderType, BufferBuilder> layerBuffers) {
        this(FALLBACK_BUFFER, layerBuffers);
    }

    public BatchableBufferSource(BufferBuilder fallbackBuffer, Map<RenderType, BufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    public VertexConsumer m_6299_(RenderType layer) {
        Optional newLayer = layer.m_110406_();
        if (!this.drawFallbackLayersFirst && !this.f_109906_.equals(newLayer) && this.f_109906_.isPresent() && !this.f_109905_.containsKey(this.f_109906_.get())) {
            this.drawFallbackLayersFirst = true;
        }
        this.f_109906_ = newLayer;
        BufferBuilder bufferBuilder = this.getOrCreateBufferBuilder(layer);
        if (bufferBuilder.m_85732_() && !layer.m_234326_()) {
            throw new IllegalStateException("Tried to write shared vertices into the same buffer");
        }
        if (!bufferBuilder.m_85732_()) {
            if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
                IrisCompat.iris$beginWithoutExtending.accept(bufferBuilder, layer.m_173186_(), layer.m_110508_());
            } else {
                bufferBuilder.m_166779_(layer.m_173186_(), layer.m_110508_());
            }
            this.activeLayers.add((Object)layer);
        } else if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || layer.f_110133_.contains("immediatelyfast:renderlast")) && this.activeLayers.contains((Object)layer)) {
            this.activeLayers.remove((Object)layer);
            this.activeLayers.add((Object)layer);
        }
        return bufferBuilder;
    }

    public void m_173043_() {
        this.f_109906_ = Optional.empty();
        this.drawFallbackLayersFirst = false;
        int sortedLayersLength = 0;
        RenderType[] sortedLayers = new RenderType[this.activeLayers.size()];
        for (RenderType layer : this.activeLayers) {
            if (this.f_109905_.containsKey(layer)) continue;
            sortedLayers[sortedLayersLength++] = layer;
        }
        if (sortedLayersLength == 0) {
            return;
        }
        Arrays.sort(sortedLayers, (l1, l2) -> Integer.compare(this.getLayerOrder((RenderType)l1), this.getLayerOrder((RenderType)l2)));
        for (int i = 0; i < sortedLayersLength; ++i) {
            this.m_109912_(sortedLayers[i]);
        }
    }

    public void m_109911_() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.m_173043_();
        for (RenderType layer : this.f_109905_.keySet()) {
            this.m_109912_(layer);
        }
    }

    public void m_109912_(RenderType layer) {
        if (this.drawFallbackLayersFirst) {
            this.m_173043_();
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove((Object)layer);
        for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
            if (bufferBuilder == null) continue;
            layer.m_276775_(bufferBuilder, RenderSystem.getVertexSorting());
        }
        this.fallbackBuffers.remove((Object)layer);
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    @Override
    public void close() {
        this.f_109906_ = Optional.empty();
        this.drawFallbackLayersFirst = false;
        for (RenderType layer : this.activeLayers) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.m_231175_().m_231200_();
            }
        }
        this.activeLayers.clear();
        this.fallbackBuffers.clear();
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected BufferBuilder getOrCreateBufferBuilder(RenderType layer) {
        if (!layer.m_234326_()) {
            return this.addNewFallbackBuffer(layer);
        }
        if (this.f_109905_.containsKey(layer)) {
            return (BufferBuilder)this.f_109905_.get(layer);
        }
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (BufferBuilder)((ReferenceSet)this.fallbackBuffers.get((Object)layer)).iterator().next();
        }
        return this.addNewFallbackBuffer(layer);
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType layer) {
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (Set)this.fallbackBuffers.get((Object)layer);
        }
        if (this.f_109905_.containsKey(layer)) {
            return Collections.singleton((BufferBuilder)this.f_109905_.get(layer));
        }
        return Collections.emptySet();
    }

    protected BufferBuilder addNewFallbackBuffer(RenderType layer) {
        BufferBuilder bufferBuilder = BufferBuilderPool.get();
        ((ReferenceSet)this.fallbackBuffers.computeIfAbsent((Object)layer, k -> new ReferenceLinkedOpenHashSet())).add((Object)bufferBuilder);
        return bufferBuilder;
    }

    protected int getLayerOrder(RenderType layer) {
        if (layer == null) {
            return Integer.MAX_VALUE;
        }
        if (layer instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType multiPhase = (RenderType.CompositeRenderType)layer;
            ResourceLocation textureId = multiPhase.m_173265_().f_110576_.m_142706_().orElse(null);
            if (textureId != null) {
                if (textureId.toString().startsWith("minecraft:textures/entity/horse/")) {
                    String horseTexturePath = textureId.toString().substring("minecraft:textures/entity/horse/".length());
                    if (horseTexturePath.startsWith("horse_markings")) {
                        return 2;
                    }
                    if (horseTexturePath.startsWith("armor/")) {
                        return 3;
                    }
                    return 1;
                }
                if (textureId.equals((Object)Sheets.f_265912_)) {
                    return 1;
                }
            }
        }
        if (!layer.f_110393_) {
            return Integer.MIN_VALUE;
        }
        return 0x7FFFFFFE;
    }
}

