/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerDouble
implements ISerializer<Double> {
    public static final ISerializer<Double> SERIALIZER = new SerializerDouble();

    private SerializerDouble() {
    }

    @Override
    public Double fromJSON(JsonElement json) {
        return json.getAsDouble();
    }

    @Override
    public JsonElement toJSON(Double toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Double fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.readDouble();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Double toWrite) {
        buffer.writeDouble(toWrite.doubleValue());
    }

    @Override
    public Tag toNBT(Double toWrite) {
        return DoubleTag.m_128500_((double)toWrite);
    }

    @Override
    public Double fromNBT(Tag nbt) {
        if (nbt instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)nbt;
            return doubleTag.m_7061_();
        }
        throw new NBTParseException("Expected NBT to be a double tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

