/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import noppes.mpm.ModelData;
import noppes.mpm.ModelEyeData;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.ServerTickHandler;
import noppes.mpm.client.ClientProxy;
import noppes.mpm.client.MpmCamera;
import noppes.mpm.client.MpmKeys;
import noppes.mpm.client.SkinUtil;
import noppes.mpm.client.fx.EntityEnderFX;
import noppes.mpm.client.gui.GuiCreationScreenInterface;
import noppes.mpm.client.gui.GuiMPM;
import noppes.mpm.client.parts.MpmPartData;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.mixin.LivingEntityMixin;
import noppes.mpm.packets.Packets;
import noppes.mpm.packets.server.PacketAnimationUpdate;
import noppes.mpm.packets.server.PacketPing;
import noppes.mpm.sync.WebApi;
import noppes.mpm.util.MPMEntityUtil;

public class ClientEventHandler {
    public static float partialTick = 0.0f;
    private long lastAltClick = 0L;
    private boolean altIsPressed = false;
    private Level prevWorld;
    private static final Predicate<Player> playerSelector = Predicates.and((Predicate[])new Predicate[]{new Predicate<Player>(){
        final double range = 6400.0;

        public boolean apply(Player entity) {
            return entity != Minecraft.m_91087_().f_91074_ && entity.m_20280_((Entity)Minecraft.m_91087_().f_91074_) <= 6400.0;
        }
    }});
    public static List<Player> playerList;
    private static final ResourceLocation female_death;
    private static final ResourceLocation female_hurt;
    private static final ResourceLocation female_attack;
    private static final ResourceLocation male_death;
    private static final ResourceLocation male_hurt;
    private static final ResourceLocation male_attack;
    private static final ResourceLocation goblin_death;
    private static final ResourceLocation goblin_hurt;
    private static final ResourceLocation goblin_attack;
    public static MpmCamera camera;

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlayLevelSoundEvent.AtEntity event) {
        LocalPlayer player;
        block18: {
            block17: {
                Entity entity = event.getEntity();
                if (!(entity instanceof LocalPlayer)) break block17;
                player = (LocalPlayer)entity;
                if (event.getSound() != null) break block18;
            }
            return;
        }
        ModelData data = ModelData.get((Player)player);
        if (data == null || data.soundType == 0) {
            return;
        }
        ResourceLocation sound = null;
        if (event.getSound() == SoundEvents.f_12323_ && !player.m_21224_() && !((LivingEntityMixin)player).isDead()) {
            if (data.soundType == 1) {
                sound = female_hurt;
            } else if (data.soundType == 2) {
                sound = male_hurt;
            } else if (data.soundType == 3) {
                sound = goblin_hurt;
            }
        }
        if (event.getSound() == SoundEvents.f_12322_) {
            if (data.soundType == 1) {
                sound = female_death;
            } else if (data.soundType == 2) {
                sound = male_death;
            } else if (data.soundType == 3) {
                sound = goblin_death;
            }
        }
        if (sound != null) {
            event.setSound(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvent.m_262824_((ResourceLocation)sound)));
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        LocalPlayer player;
        block12: {
            block11: {
                Entity entity;
                if (event.getAmount() < 1.0f || !event.getSource().m_269415_().f_268677_().equals("player") || !((entity = event.getSource().m_7639_()) instanceof LocalPlayer)) {
                    return;
                }
                player = (LocalPlayer)entity;
                if (event.getEntity().m_21223_() < 0.0f) break block11;
                float f = player.m_21216_();
                Objects.requireNonNull(player);
                if (!(f > 20.0f / 2.0f)) break block12;
            }
            return;
        }
        ModelData data = ModelData.get((Player)player);
        if (data == null || data.soundType == 0) {
            return;
        }
        ResourceLocation sound = null;
        if (data.soundType == 1) {
            sound = female_attack;
        } else if (data.soundType == 2) {
            sound = male_attack;
        } else if (data.soundType == 3) {
            sound = goblin_attack;
        }
        if (sound != null) {
            float pitch = (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f;
            player.m_9236_().m_5594_((Player)player, player.m_20183_(), SoundEvent.m_262824_((ResourceLocation)sound), SoundSource.PLAYERS, 0.9876543f, pitch);
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null) {
            return;
        }
        if (MpmKeys.Screen.m_90857_()) {
            ModelData data = ModelData.get((Player)mc.f_91074_);
            data.setAnimation(EnumAnimation.NONE);
            if (mc.f_91080_ == null) {
                mc.m_91152_((Screen)new GuiMPM());
            }
        }
        if (mc.f_91080_ == null) {
            // empty if block
        }
        if (!mc.m_91302_()) {
            return;
        }
        if (MpmKeys.MPM1.m_90857_()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button1);
        }
        if (MpmKeys.MPM2.m_90857_()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button2);
        }
        if (MpmKeys.MPM3.m_90857_()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button3);
        }
        if (MpmKeys.MPM4.m_90857_()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button4);
        }
        if (MpmKeys.MPM5.m_90857_()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button5);
        }
        InputConstants.Key i = InputConstants.Type.KEYSYM.m_84895_(event.getKey());
        if (MpmKeys.Camera.m_90857_() && mc.f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            long time = System.currentTimeMillis();
            if (!this.altIsPressed) {
                if (time - this.lastAltClick < 400L) {
                    camera.reset();
                } else {
                    camera.enable();
                    this.lastAltClick = time;
                }
            }
            this.altIsPressed = true;
        } else if (this.altIsPressed) {
            this.altIsPressed = false;
        }
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.m_91302_() && mc.f_91063_.m_109153_().m_90594_() && ClientEventHandler.camera.enabled && this.altIsPressed)) {
            return;
        }
        ClientEventHandler.camera.cameraDistance = (float)((double)ClientEventHandler.camera.cameraDistance - event.getScrollDelta());
        if (ClientEventHandler.camera.cameraDistance > 14.0f) {
            ClientEventHandler.camera.cameraDistance = 14.0f;
        } else if (ClientEventHandler.camera.cameraDistance < 1.0f) {
            ClientEventHandler.camera.cameraDistance = 1.0f;
        }
        event.setCanceled(true);
    }

    public static void processAnimation(int type) {
        if (type < 0) {
            return;
        }
        PacketAnimationUpdate.setAnimation((Player)Minecraft.m_91087_().f_91074_, EnumAnimation.values()[type]);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTick = event.renderTickTime;
        }
        camera.update(event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == LogicalSide.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            if (this.prevWorld != null) {
                this.prevWorld = null;
                SkinUtil.lastSkinTick = -20L;
            }
            return;
        }
        if (this.prevWorld != mc.f_91073_) {
            GuiCreationScreenInterface.Message = "message.noserver";
            ModelData data = ModelData.get((Player)mc.f_91074_);
            MorePlayerModels.HasServerSide = true;
            Packets.sendServer(new PacketPing(MorePlayerModels.Version, data.writeToNBT()));
            MorePlayerModels.HasServerSide = false;
            this.prevWorld = mc.f_91073_;
        }
        ++SkinUtil.lastSkinTick;
        if (mc.f_91073_.m_6106_().m_6793_() % 20L == 0L) {
            playerList = mc.f_91073_.m_6907_().stream().filter(playerSelector).collect(Collectors.toList());
            WebApi.instance.run();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        ClientProxy.data = null;
        Player player = event.player;
        ModelData data = ModelData.get(player);
        LivingEntity entity = data.getEntity(player);
        Minecraft mc = Minecraft.m_91087_();
        if (entity != null) {
            MPMEntityUtil.copy((LivingEntity)player, entity);
        }
        if (!MorePlayerModels.HasServerSide && entity == null) {
            for (MpmPartData pd : data.mpmParts) {
                if (!(pd instanceof ModelEyeData)) continue;
                ((ModelEyeData)pd).update(player);
            }
        }
        if (data.inLove > 0) {
            --data.inLove;
            if (player.m_217043_().m_188499_()) {
                double d0 = player.m_217043_().m_188583_() * 0.02;
                double d1 = player.m_217043_().m_188583_() * 0.02;
                double d2 = player.m_217043_().m_188583_() * 0.02;
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, player.m_20185_() + (double)(player.m_217043_().m_188501_() * player.m_20205_() * 2.0f) - (double)player.m_20205_(), player.m_20186_() + 0.5 + (double)(player.m_217043_().m_188501_() * player.m_20206_()), player.m_20189_() + (double)(player.m_217043_().m_188501_() * player.m_20205_() * 2.0f) - (double)player.m_20205_(), d0, d1, d2);
            }
        }
        if (data.animation == EnumAnimation.CRY) {
            float f1 = player.m_146909_() * (float)Math.PI / 180.0f;
            float dx = -Mth.m_14031_((float)f1);
            float dz = Mth.m_14089_((float)f1);
            float width = entity == null ? player.m_20205_() : entity.m_20205_();
            int i = 0;
            while ((float)i < 10.0f) {
                float f2 = (player.m_217043_().m_188501_() - 0.5f) * width * 0.5f + dx * 0.15f;
                float f3 = (player.m_217043_().m_188501_() - 0.5f) * width * 0.5f + dz * 0.15f;
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, player.m_20185_() + (double)f2, player.m_20186_() - (double)data.getBodyY() + (double)1.1f - player.m_6049_(), player.m_20189_() + (double)f3, (double)1.0E-25f, 0.0, (double)1.0E-25f);
                ++i;
            }
        }
        ServerTickHandler.checkMovementAnimation(player, data);
        if (data.animation != EnumAnimation.NONE) {
            ServerTickHandler.checkAnimation(player, data);
        }
        if (data.animation == EnumAnimation.DEATH) {
            if (player.f_20919_ == 0) {
                player.m_5496_(SoundEvents.f_11915_, 1.0f, 1.0f);
            }
            if (player.f_20919_ < 19) {
                ++player.f_20919_;
            }
        }
        if (data.prevAnimation != data.animation && data.prevAnimation == EnumAnimation.DEATH && !player.m_21224_()) {
            player.f_20919_ = 0;
        }
        data.prevMoveAnimation = data.moveAnimation;
        data.prevAnimation = data.animation;
        data.prevPosX = player.m_20185_();
        data.prevPosY = player.m_20186_();
        data.prevPosZ = player.m_20189_();
        ModelPartData particles = null;
        if (particles != null) {
            this.spawnParticles(player, data, particles);
        }
    }

    private void spawnParticles(Player player, ModelData data, ModelPartData particles) {
        if (!MorePlayerModels.EnableParticles) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        double height = player.m_6049_() + (double)data.getBodyY();
        RandomSource rand = player.m_217043_();
        for (int i = 0; i < 2; ++i) {
            EntityEnderFX fx = new EntityEnderFX((AbstractClientPlayer)player, player.m_20208_(0.5), player.m_20187_() - height - 0.25, player.m_20262_(0.5), (rand.m_188500_() - 0.5) * 2.0, -rand.m_188500_(), (rand.m_188500_() - 0.5) * 2.0, particles);
            minecraft.f_91061_.m_107344_((Particle)fx);
        }
    }

    static {
        female_death = new ResourceLocation("moreplayermodels:human.female.death");
        female_hurt = new ResourceLocation("moreplayermodels:human.female.hurt");
        female_attack = new ResourceLocation("moreplayermodels:human.female.attack");
        male_death = new ResourceLocation("moreplayermodels:human.male.death");
        male_hurt = new ResourceLocation("moreplayermodels:human.male.hurt");
        male_attack = new ResourceLocation("moreplayermodels:human.male.attack");
        goblin_death = new ResourceLocation("moreplayermodels:goblin.male.death");
        goblin_hurt = new ResourceLocation("moreplayermodels:goblin.male.hurt");
        goblin_attack = new ResourceLocation("moreplayermodels:goblin.male.attack");
        camera = new MpmCamera();
    }
}

