/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import noppes.mpm.LogWriter;
import noppes.mpm.ModelData;
import noppes.mpm.client.Preset;

public class PresetController {
    public HashMap<String, Preset> presets = new HashMap();
    private File dir;
    public static PresetController instance;

    public PresetController(File dir) {
        instance = this;
        this.dir = dir;
    }

    public Preset getPreset(String username) {
        if (this.presets.isEmpty()) {
            this.load();
        }
        if (username == null || username.isEmpty()) {
            return null;
        }
        return this.presets.get(username.toLowerCase());
    }

    public void load() {
        CompoundTag compound = this.loadPreset();
        HashMap<String, Preset> presets = new HashMap<String, Preset>();
        if (compound != null) {
            ListTag list = compound.m_128437_("Presets", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag comp = list.m_128728_(i);
                Preset preset = new Preset();
                preset.readFromNBT(comp);
                presets.put(preset.name.toLowerCase(), preset);
            }
            if (compound.m_128441_("PresetSelected")) {
                ModelData data = ModelData.get((Player)Minecraft.m_91087_().f_91074_);
                if (data.presetName.isEmpty()) {
                    data.presetName = compound.m_128461_("PresetSelected");
                }
            }
        }
        if (presets.isEmpty()) {
            Preset preset = new Preset();
            preset.data = ModelData.get((Player)Minecraft.m_91087_().f_91074_);
            preset.name = "Default";
            preset.menu = true;
            presets.put("default", preset);
            ModelData data = new ModelData();
            preset = new Preset();
            preset.name = "Normal";
            preset.data = data;
            preset.menu = true;
            presets.put("normal", preset);
        }
        this.presets = presets;
    }

    private CompoundTag loadPreset() {
        String filename = "presets.dat";
        try {
            File file = new File(this.dir, filename);
            if (!file.exists()) {
                return null;
            }
            return NbtIo.m_128939_((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            LogWriter.except(e);
            try {
                File file = new File(this.dir, filename + "_old");
                if (!file.exists()) {
                    return null;
                }
                return NbtIo.m_128939_((InputStream)new FileInputStream(file));
            }
            catch (Exception e2) {
                LogWriter.except(e2);
                return null;
            }
        }
    }

    public void save() {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (Preset preset : this.presets.values()) {
            list.add((Object)preset.writeToNBT());
        }
        compound.m_128365_("Presets", (Tag)list);
        this.savePreset(compound);
    }

    private void savePreset(CompoundTag compound) {
        String filename = "presets.dat";
        try {
            File file = new File(this.dir, filename + "_new");
            File file1 = new File(this.dir, filename + "_old");
            File file2 = new File(this.dir, filename);
            NbtIo.m_128947_((CompoundTag)compound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
            e.printStackTrace();
        }
    }

    public void addPreset(Preset preset) {
        this.presets.put(preset.name.toLowerCase(), preset);
        this.save();
    }

    public void removePreset(String preset) {
        if (preset == null) {
            return;
        }
        this.presets.remove(preset.toLowerCase());
        this.save();
    }
}

