/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import noppes.mpm.client.gui.util.GuiNPCInterface;
import noppes.mpm.client.gui.util.GuiNpcButton;
import noppes.mpm.client.gui.util.GuiNpcTextField;
import noppes.mpm.client.gui.util.ITextfieldListener;

public class GuiModelColor
extends GuiNPCInterface
implements ITextfieldListener {
    private Screen parent;
    private static final ResourceLocation colorPicker = new ResourceLocation("moreplayermodels:textures/gui/color.png");
    private static final ResourceLocation colorgui = new ResourceLocation("moreplayermodels:textures/gui/color_gui.png");
    private int colorX;
    private int colorY;
    private GuiNpcTextField textfield;
    public int color;
    private ColorCallback callback;

    public GuiModelColor(Screen parent, int color, ColorCallback callback) {
        this.parent = parent;
        this.callback = callback;
        this.ySize = 230;
        this.closeOnEsc = false;
        this.background = colorgui;
        this.color = color;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.colorX = this.guiLeft + 4;
        this.colorY = this.guiTop + 50;
        this.textfield = new GuiNpcTextField(0, this, this.guiLeft + 35, this.guiTop + 25, 60, 20, this.getColor());
        this.addTextField(this.textfield);
        this.addButton(new GuiNpcButton(this, 66, this.guiLeft + 107, this.guiTop + 8, 20, 20, "X"));
        this.textfield.m_94202_(this.color);
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (guibutton.id == 66) {
            this.close();
        }
    }

    @Override
    public boolean m_5534_(char c, int i) {
        String prev = this.textfield.m_94155_();
        boolean bo = super.m_5534_(c, i);
        String newText = this.textfield.m_94155_();
        if (newText.equals(prev)) {
            return bo;
        }
        try {
            this.color = Integer.parseInt(this.textfield.m_94155_(), 16);
            this.callback.color(this.color);
            this.textfield.m_94202_(this.color);
        }
        catch (NumberFormatException e) {
            this.textfield.m_94144_(prev);
        }
        return bo;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int par1, int par2, float par3) {
        super.m_88315_(graphics, par1, par2, par3);
        graphics.m_280218_(colorPicker, this.colorX, this.colorY, 0, 0, 120, 120);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean m_6375_(double i, double j, int k) {
        boolean bo = super.m_6375_(i, j, k);
        if (i < (double)this.colorX || i > (double)(this.colorX + 120) || j < (double)this.colorY || j > (double)(this.colorY + 120)) {
            return bo;
        }
        InputStream stream = null;
        try {
            Resource resource = (Resource)this.f_96541_.m_91098_().m_213713_(colorPicker).get();
            stream = resource.m_215507_();
            BufferedImage bufferedimage = ImageIO.read(stream);
            int color = bufferedimage.getRGB((int)(i - (double)this.guiLeft - 4.0) * 4, (int)(j - (double)this.guiTop - 50.0) * 4) & 0xFFFFFF;
            if (color != 0) {
                this.color = color;
                this.callback.color(color);
                this.textfield.m_94202_(color);
                this.textfield.m_94144_(this.getColor());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        try {
            this.color = Integer.parseInt(textfield.m_94155_(), 16);
        }
        catch (NumberFormatException e) {
            this.color = 0;
        }
        this.callback.color(this.color);
        textfield.m_94202_(this.color);
    }

    public String getColor() {
        Object str = Integer.toHexString(this.color);
        while (((String)str).length() < 6) {
            str = "0" + (String)str;
        }
        return str;
    }

    @Override
    public void save() {
    }

    public static interface ColorCallback {
        public void color(int var1);
    }
}

