/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client.model.animation;

import java.util.HashMap;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import noppes.mpm.ModelData;
import noppes.mpm.client.model.animation.AniBlank;
import noppes.mpm.client.model.animation.AniBow;
import noppes.mpm.client.model.animation.AniCrawling;
import noppes.mpm.client.model.animation.AniDancing;
import noppes.mpm.client.model.animation.AniHug;
import noppes.mpm.client.model.animation.AniNo;
import noppes.mpm.client.model.animation.AniPoint;
import noppes.mpm.client.model.animation.AniWaving;
import noppes.mpm.client.model.animation.AniYes;
import noppes.mpm.client.model.animation.AnimationBase;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumParts;

public class AnimationHandler {
    private static final HashMap<EnumAnimation, AnimationBase> ANIMATIONS = new HashMap();

    public static void animateBipedPre(ModelData data, HumanoidModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        bipedModel.f_102810_.f_104202_ = 0.0f;
        bipedModel.f_102810_.f_104201_ = 0.0f;
        bipedModel.f_102810_.f_104200_ = 0.0f;
        bipedModel.f_102810_.f_104205_ = 0.0f;
        bipedModel.f_102810_.f_104204_ = 0.0f;
        bipedModel.f_102810_.f_104203_ = 0.0f;
        bipedModel.f_102808_.f_104203_ = 0.0f;
        bipedModel.f_102809_.f_104203_ = 0.0f;
        bipedModel.f_102808_.f_104205_ = 0.0f;
        bipedModel.f_102809_.f_104205_ = 0.0f;
        bipedModel.f_102808_.f_104200_ = 0.0f;
        bipedModel.f_102809_.f_104200_ = 0.0f;
        bipedModel.f_102808_.f_104201_ = 0.0f;
        bipedModel.f_102809_.f_104201_ = 0.0f;
        bipedModel.f_102808_.f_104202_ = 0.0f;
        bipedModel.f_102809_.f_104202_ = 0.0f;
        bipedModel.f_102814_.f_104203_ = 0.0f;
        bipedModel.f_102814_.f_104204_ = 0.0f;
        bipedModel.f_102814_.f_104205_ = 0.0f;
        bipedModel.f_102813_.f_104203_ = 0.0f;
        bipedModel.f_102813_.f_104204_ = 0.0f;
        bipedModel.f_102813_.f_104205_ = 0.0f;
        bipedModel.f_102812_.f_104200_ = 0.0f;
        bipedModel.f_102812_.f_104201_ = 2.0f;
        bipedModel.f_102812_.f_104202_ = 0.0f;
        bipedModel.f_102811_.f_104200_ = 0.0f;
        bipedModel.f_102811_.f_104201_ = 2.0f;
        bipedModel.f_102811_.f_104202_ = 0.0f;
        AnimationBase animation = AnimationHandler.getAnimationFor(data.moveAnimation);
        if (animation != null) {
            animation.animatePre(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, data.animationStart);
        }
        if ((animation = AnimationHandler.getAnimationFor(data.animation)) != null) {
            animation.animatePre(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, data.animationStart);
        }
        if (bipedModel.f_102817_ && data.moveAnimation == EnumAnimation.CRAWL) {
            bipedModel.f_102817_ = false;
        }
    }

    public static void animateBipedPost(ModelData data, HumanoidModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimationBase animation = AnimationHandler.getAnimationFor(data.moveAnimation);
        if (animation != null) {
            animation.animatePost(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, data.animationStart);
        }
        if ((animation = AnimationHandler.getAnimationFor(data.animation)) != null) {
            animation.animatePost(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, (Entity)livingEntity, bipedModel, data.animationStart);
        }
        if (bipedModel.f_102817_ && data.moveAnimation != EnumAnimation.CRAWL) {
            bipedModel.f_102810_.f_104203_ = 0.5f / data.getPartConfig((EnumParts)EnumParts.BODY).scaleY;
        }
        if (bipedModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)bipedModel;
            playerModel.f_103376_.m_104315_(playerModel.f_102814_);
            playerModel.f_103377_.m_104315_(playerModel.f_102813_);
            playerModel.f_103374_.m_104315_(playerModel.f_102812_);
            playerModel.f_103375_.m_104315_(playerModel.f_102811_);
            playerModel.f_103378_.m_104315_(playerModel.f_102810_);
        }
        bipedModel.f_102809_.m_104315_(bipedModel.f_102808_);
    }

    public static void addAnimation(EnumAnimation enumAnimation, AnimationBase animationBase) {
        ANIMATIONS.put(enumAnimation, animationBase);
    }

    public static HashMap<EnumAnimation, AnimationBase> getAllAnimations() {
        return ANIMATIONS;
    }

    public static AnimationBase getAnimationFor(EnumAnimation animation) {
        try {
            if (!ANIMATIONS.containsKey((Object)animation)) {
                throw new IllegalAccessException("Animation " + animation.name() + " is not registered, maybe you forgot?");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ANIMATIONS.get((Object)animation);
    }

    public static void initAnimations() {
        AnimationHandler.addAnimation(EnumAnimation.NONE, new AniBlank());
        AnimationHandler.addAnimation(EnumAnimation.SLEEP, new AniBlank());
        AnimationHandler.addAnimation(EnumAnimation.CRAWL, new AniCrawling());
        AnimationHandler.addAnimation(EnumAnimation.HUG, new AniHug());
        AnimationHandler.addAnimation(EnumAnimation.DANCE, new AniDancing());
        AnimationHandler.addAnimation(EnumAnimation.WAVE, new AniWaving());
        AnimationHandler.addAnimation(EnumAnimation.WAG, new AniBlank());
        AnimationHandler.addAnimation(EnumAnimation.BOW, new AniBow());
        AnimationHandler.addAnimation(EnumAnimation.YES, new AniYes());
        AnimationHandler.addAnimation(EnumAnimation.NO, new AniNo());
        AnimationHandler.addAnimation(EnumAnimation.POINT, new AniPoint());
        AnimationHandler.addAnimation(EnumAnimation.DEATH, new AniBlank());
        AnimationHandler.addAnimation(EnumAnimation.CRY, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.f_102808_.f_104203_ = 0.7f;
                model.f_102809_.f_104203_ = 0.7f;
            }
        });
        AnimationHandler.addAnimation(EnumAnimation.SIT, new AnimationBase(){

            @Override
            public void animatePre(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
                model.f_102609_ = true;
            }

            @Override
            public void animatePost(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Entity entity, HumanoidModel model, int animationStart) {
            }
        });
    }
}

