/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import noppes.mpm.ModelData;
import noppes.mpm.client.SkinUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"getModelName"}, cancellable=true)
    private void getModelName(CallbackInfoReturnable<String> cir) {
        ModelData data = ModelData.get((Player)this);
        if (data != null && data.modelType != 0) {
            if (data.modelType == 1) {
                cir.setReturnValue((Object)"default");
            } else {
                cir.setReturnValue((Object)"slim");
            }
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSkinTextureLocation"}, cancellable=true)
    private void getTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation location;
        EntityRenderer renderer;
        Player player = (Player)this;
        ModelData data = ModelData.get(player);
        SkinUtil.load(data, player);
        if (data.resourceLoaded && data.resourceLocation != null) {
            cir.setReturnValue((Object)data.resourceLocation);
            cir.cancel();
        }
        if (!cir.isCancelled() && data.getEntity(player) != null && (renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)data.getEntity(player))) != null && (location = renderer.m_5478_((Entity)data.getEntity(player))) != null) {
            cir.setReturnValue((Object)location);
            cir.cancel();
        }
    }
}

