/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateJarContraption {
    public int entityID;
    public BlockPos structurePos;
    public CompoundTag structureTag;
    public int fillLevel;

    public PacketUpdateJarContraption(FriendlyByteBuf buf) {
        this.structurePos = buf.m_130135_();
        this.structureTag = buf.m_130260_();
        this.fillLevel = buf.readInt();
        this.entityID = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.structurePos);
        buf.m_130079_(this.structureTag);
        buf.writeInt(this.fillLevel);
        buf.writeInt(this.entityID);
    }

    public PacketUpdateJarContraption(int entityId, BlockPos structurePos, CompoundTag tag, int fillLevel) {
        this.entityID = entityId;
        this.structurePos = structurePos;
        this.structureTag = tag;
        this.fillLevel = fillLevel;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = ArsNouveau.proxy.getClientWorld().m_6815_(this.entityID);
            if (entity instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
                contraption.getContraption().getBlocks().put(this.structurePos, new StructureTemplate.StructureBlockInfo(this.structurePos, (BlockState)BlockRegistry.SOURCE_JAR.defaultBlockState().m_61124_(SourceJar.fill, (Comparable)Integer.valueOf(this.fillLevel)), this.structureTag));
                ContraptionRenderDispatcher.invalidate((Contraption)contraption.getContraption());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

