/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.config.integrated;

import com.christofmeg.justenoughbreeding.jei.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MinecraftIntegration {
    static final String MOD = "minecraft";
    static final List<String> animalNames = new ArrayList<String>();
    static final List<String> tamableOnly = new ArrayList<String>();
    static final List<String> trustableOnly = new ArrayList<String>();
    static final Map<String, String> ingredients = new HashMap<String, String>();
    static final Map<String, Boolean> needsToBeTamed = new HashMap<String, Boolean>();
    static final Map<String, String> resultEggs = new HashMap<String, String>();
    static final Map<String, Integer> eggsAmountMin = new HashMap<String, Integer>();
    static final Map<String, Integer> eggsAmountMax = new HashMap<String, Integer>();
    static final Map<String, Integer> breedingCooldown = new HashMap<String, Integer>();
    static final Map<String, String> tamingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> tamingChance = new HashMap<String, Integer>();
    static final Map<String, List<TemperRecipe>> temperDataMap = new HashMap<String, List<TemperRecipe>>();
    static final Map<String, String> trustingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> trustingChance = new HashMap<String, Integer>();
    static final String MEAT = Utils.getEdibleMeatItemNames(true);

    public static void init() {
        CommonUtils.addTrustingOnly("allay", "*", trustableOnly, trustingIngredients, trustingChance);
        CommonUtils.addAnimal("axolotl", "minecraft:tropical_fish_bucket", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("bee", "#minecraft:flowers", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("camel", "minecraft:cactus", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("cat", "minecraft:cod, minecraft:salmon", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableOnly("cat", "minecraft:cod, minecraft:salmon", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimal("chicken", "minecraft:wheat_seeds, minecraft:pumpkin_seeds, minecraft:melon_seeds, minecraft:beetroot_seeds, minecraft:torchflower_seeds, minecraft:pitcher_pod", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("cow", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("donkey", "minecraft:golden_apple, minecraft:enchanted_golden_apple, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("donkey", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimal("fox", "#minecraft:fox_food", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTrustingOnly("fox", "#minecraft:fox_food", trustableOnly, trustingIngredients, trustingChance);
        CommonUtils.addAnimalEggLaying("frog", "minecraft:slime_ball", "minecraft:frogspawn", 1, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimal("goat", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("hoglin", "minecraft:crimson_fungus", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("horse", "minecraft:golden_apple, minecraft:enchanted_golden_apple, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("horse", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimalWithTamedTag("llama", "minecraft:wheat, minecraft:hay_block", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("llama", new String[]{"minecraft:wheat", "minecraft:hay_block"}, new int[]{3, 6}, temperDataMap);
        CommonUtils.addAnimal("mooshroom", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTamableOnly("mule", "minecraft:wheat, minecraft:hay_block", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTemperAnimal("mule", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimal("ocelot", "minecraft:cod, minecraft:salmon", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTrustingOnly("ocelot", "minecraft:cod, minecraft:salmon", trustableOnly, trustingIngredients, trustingChance);
        CommonUtils.addAnimal("panda", "minecraft:bamboo", animalNames, ingredients, breedingCooldown);
        CommonUtils.addTamableOnly("parrot", "minecraft:wheat_seeds, minecraft:pumpkin_seeds, minecraft:melon_seeds, minecraft:beetroot_seeds, minecraft:torchflower_seeds, minecraft:pitcher_pod", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimal("pig", "minecraft:carrot, minecraft:potato, minecraft:beetroot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("rabbit", "minecraft:dandelion, minecraft:carrot, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("sheep", "minecraft:wheat", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalEggLaying("sniffer", "minecraft:torchflower_seeds", "minecraft:sniffer_egg", 1, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimal("strider", "minecraft:warped_fungus", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimalWithTamedTag("trader_llama", "minecraft:wheat, minecraft:hay_block", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTemperAnimal("trader_llama", new String[]{"minecraft:wheat", "minecraft:hay_block"}, new int[]{3, 6}, temperDataMap);
        CommonUtils.addAnimalEggLaying("turtle", "minecraft:seagrass", "minecraft:turtle_egg", 4, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimalWithTamedTag("wolf", MEAT, animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableOnly("wolf", "minecraft:bone", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addAnimalNames(animalNames, ingredients, MOD, breedingCooldown, needsToBeTamed);
        CommonUtils.addTamableAnimalNames(tamableOnly, tamingIngredients, tamingChance, MOD);
        CommonUtils.addTrustingAnimalNames(trustableOnly, trustingIngredients, trustingChance, MOD);
        CommonUtils.addAnimalTempers(temperDataMap, MOD);
        CommonUtils.addAnimalNames(animalNames, ingredients, MOD, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
    }
}

