/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.utility.ItemUtils;
import com.simibubi.create.AllBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MaterialItemStorage {
    private Map<String, MaterialItem> storage;

    private MaterialItemStorage(Set<String> properties) {
        this.storage = new HashMap<String, MaterialItem>(properties.size());
        for (String property : properties) {
            this.storage.put(property, new MaterialItem(AllBlocks.COPYCAT_BASE.getDefaultState(), ItemStack.f_41583_));
        }
    }

    public static MaterialItemStorage create(Set<String> properties) {
        return new MaterialItemStorage(properties);
    }

    public void storeMaterialItem(String property, MaterialItem materialItem) {
        this.storage.put(property, materialItem);
    }

    @Nullable
    public MaterialItem getMaterialItem(String property) {
        return this.storage.get(property);
    }

    public Set<String> getAllProperties() {
        return this.storage.keySet();
    }

    public Set<BlockState> getAllMaterials() {
        return this.storage.values().stream().map(MaterialItem::material).collect(Collectors.toSet());
    }

    public Set<MaterialItem> getAllMaterialItems() {
        return new HashSet<MaterialItem>(this.storage.values());
    }

    public List<ItemStack> getAllConsumedItems() {
        return this.storage.values().stream().map(MaterialItem::consumedItem).dropWhile(itemStack -> itemStack.equals(ItemStack.f_41583_)).collect(Collectors.toList());
    }

    public Map<String, BlockState> getMaterialMap() {
        return this.storage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ((MaterialItem)s.getValue()).material));
    }

    public boolean hasCustomMaterial(String property) {
        return this.storage.get(property).hasCustomMaterial();
    }

    public void remapStorage(Function<String, String> keyMapper) {
        HashMap<String, MaterialItem> newStorage = new HashMap<String, MaterialItem>();
        this.storage.forEach((key, materialItem) -> newStorage.put((String)keyMapper.apply((String)key), (MaterialItem)materialItem));
        this.storage = newStorage;
    }

    public CompoundTag serialize() {
        CompoundTag root = new CompoundTag();
        this.storage.forEach((key, materialItem) -> root.m_128365_(key, (Tag)materialItem.serialize()));
        return root;
    }

    public CompoundTag serializeSafe() {
        CompoundTag root = new CompoundTag();
        this.storage.forEach((key, materialItem) -> root.m_128365_(key, (Tag)materialItem.serializeSafe()));
        return root;
    }

    public boolean deserialize(CompoundTag tag) {
        AtomicBoolean anyUpdated = new AtomicBoolean(false);
        tag.m_128431_().forEach(key -> {
            MaterialItem newVersion = MaterialItem.deserialize(tag.m_128469_(key));
            MaterialItem oldVersion = this.storage.put((String)key, newVersion);
            if (!(oldVersion == null || newVersion.material() == oldVersion.material() && newVersion.enableCT() == oldVersion.enableCT() || anyUpdated.get())) {
                anyUpdated.set(true);
            }
        });
        return anyUpdated.get();
    }

    public static class MaterialItem {
        private BlockState material;
        private ItemStack consumedItem;
        private boolean enableCT;

        public MaterialItem(BlockState material, ItemStack consumedItem) {
            this(material, consumedItem, true);
        }

        public MaterialItem(BlockState material, ItemStack consumedItem, boolean enableCT) {
            this.material = material;
            this.consumedItem = consumedItem;
            this.enableCT = enableCT;
        }

        public CompoundTag serialize() {
            CompoundTag root = new CompoundTag();
            root.m_128365_("material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
            root.m_128365_("consumedItem", ItemUtils.serializeNBT(this.consumedItem));
            root.m_128379_("enableCT", this.enableCT);
            return root;
        }

        public CompoundTag serializeSafe() {
            CompoundTag root = new CompoundTag();
            root.m_128365_("material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
            ItemStack stackEmpty = this.consumedItem.m_41777_();
            stackEmpty.m_41751_(null);
            root.m_128365_("consumedItem", ItemUtils.serializeNBT(stackEmpty));
            root.m_128379_("enableCT", this.enableCT);
            return root;
        }

        public static MaterialItem deserialize(CompoundTag tag) {
            return new MaterialItem(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("material")), ItemStack.m_41712_((CompoundTag)tag.m_128469_("consumedItem")), !tag.m_128441_("enableCT") || tag.m_128471_("enableCT"));
        }

        public BlockState material() {
            return this.material;
        }

        public ItemStack consumedItem() {
            return this.consumedItem;
        }

        public boolean enableCT() {
            return this.enableCT;
        }

        public void setMaterial(BlockState material) {
            this.material = material;
        }

        public void setConsumedItem(ItemStack stack) {
            this.consumedItem = ItemUtils.copyStackWithSize(stack, 1);
        }

        public void setEnableCT(boolean enableCT) {
            this.enableCT = enableCT;
        }

        public boolean hasCustomMaterial() {
            return !this.material.m_60713_((Block)AllBlocks.COPYCAT_BASE.get());
        }
    }
}

