/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.mixin.copycat.VoxelShapeAccessor;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFaceUtils {
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cacheMap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(2048, 0.25f){

            protected void rehash(int i) {
            }
        };
        cacheMap.defaultReturnValue((byte)127);
        return cacheMap;
    });

    private static boolean processBlockFace(BlockGetter level, BlockState fromState, BlockPos fromPos, BlockState toState, BlockPos toPos, Direction fromFace, BiFunction<VoxelShape, VoxelShape, Boolean> operation, Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cache) {
        boolean mismatch;
        if (level instanceof ScaledBlockAndTintGetter) {
            VoxelShape toShape;
            IMultiStateCopycatBlock copycatBlock2;
            VoxelShape fromShape;
            IMultiStateCopycatBlock copycatBlock;
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            Vec3i scale = scaledWorld.getScale();
            BlockPos truePos = scaledWorld.getTruePos(fromPos);
            Block block = fromState.m_60734_();
            if (block instanceof IMultiStateCopycatBlock && (copycatBlock = (IMultiStateCopycatBlock)block).vectorScale(fromState).equals((Object)scale)) {
                String property = scaledWorld.getPropertyForRender(fromState, fromPos);
                if (!copycatBlock.partExists(fromState, property)) {
                    return false;
                }
                Vec3i inner = copycatBlock.getVectorFromProperty(fromState, property);
                fromShape = BlockFaceUtils.getPartialFaceShape(fromState.m_60768_((BlockGetter)scaledWorld.getWrapped(), truePos), fromFace, (double)inner.m_123341_() / (double)scale.m_123341_(), (double)inner.m_123342_() / (double)scale.m_123342_(), (double)inner.m_123343_() / (double)scale.m_123343_(), 1.0 / (double)scale.m_123341_(), 1.0 / (double)scale.m_123342_(), 1.0 / (double)scale.m_123343_());
            } else {
                fromShape = fromState.m_60655_((BlockGetter)scaledWorld.getWrapped(), truePos, fromFace);
            }
            if (fromShape.m_83281_()) {
                return false;
            }
            BlockPos toTruePos = scaledWorld.getTruePos(toPos);
            Block block2 = toState.m_60734_();
            if (block2 instanceof IMultiStateCopycatBlock && (copycatBlock2 = (IMultiStateCopycatBlock)block2).vectorScale(toState).equals((Object)scaledWorld.getScale())) {
                String toProperty = scaledWorld.getPropertyForRender(toState, toPos);
                Vec3i toInner = copycatBlock2.getVectorFromProperty(toState, toProperty);
                toShape = BlockFaceUtils.getPartialFaceShape(toState.m_60768_((BlockGetter)scaledWorld.getWrapped(), toTruePos), fromFace.m_122424_(), (double)toInner.m_123341_() / (double)scale.m_123341_(), (double)toInner.m_123342_() / (double)scale.m_123342_(), (double)toInner.m_123343_() / (double)scale.m_123343_(), 1.0 / (double)scale.m_123341_(), 1.0 / (double)scale.m_123342_(), 1.0 / (double)scale.m_123343_());
            } else {
                toShape = toState.m_60655_((BlockGetter)scaledWorld.getWrapped(), toTruePos, fromFace.m_122424_());
            }
            return operation.apply(fromShape, toShape);
        }
        Block.BlockStatePairKey blockStatePair = new Block.BlockStatePairKey(fromState, toState, fromFace);
        byte cached = cache.getAndMoveToFirst((Object)blockStatePair);
        if (cached != 127) {
            return cached == 0;
        }
        VoxelShape fromShape = fromState.m_60655_(level, fromPos, fromFace);
        if (fromShape.m_83281_()) {
            return false;
        }
        VoxelShape toShape = toState.m_60655_(level, toPos, fromFace.m_122424_());
        boolean bl = mismatch = operation.apply(fromShape, toShape) == false;
        if (cache.size() == 2048) {
            cache.removeLastByte();
        }
        cache.putAndMoveToFirst((Object)blockStatePair, (byte)(mismatch ? 1 : 0));
        return !mismatch;
    }

    public static boolean canOcclude(BlockGetter level, BlockState occludedState, BlockPos occludedPos, BlockState occludingState, BlockPos occludingPos, Direction occludedFace) {
        return BlockFaceUtils.processBlockFace(level, occludedState, occludedPos, occludingState, occludingPos, occludedFace, (occluded, occluding) -> !Shapes.m_83157_((VoxelShape)occluded, (VoxelShape)occluding, (BooleanOp)BooleanOp.f_82685_), OCCLUSION_CACHE.get());
    }

    public static VoxelShape getPartialFaceShape(VoxelShape voxelShape, Direction direction, double startX, double startY, double startZ, double sizeX, double sizeY, double sizeZ) {
        Direction.Axis axis = direction.m_122434_();
        double endX = startX + sizeX;
        double endY = startY + sizeY;
        double endZ = startZ + sizeZ;
        VoxelShape bounds = Shapes.m_83048_((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        voxelShape = Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)bounds, (BooleanOp)BooleanOp.f_82689_);
        int axisSize = ((VoxelShapeAccessor)voxelShape).copycats$getShape().m_82850_(axis);
        int i = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(endX, endY, endZ)), (double)-1.0, (double)axisSize)) - 1 : Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(startX, startY, startZ)), (double)-1.0, (double)axisSize));
        return new SliceShape(voxelShape, axis, i);
    }
}

