/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.mru.packing;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MRU/Packer");

    public static void pack(@NotNull Path outputDirectory, String ... globs) {
        LOGGER.info("Beginning to pack files within '{}' that match the globs: {}", (Object)outputDirectory, (Object)Arrays.toString(globs));
        ArrayList<PathMatcher> globsMatchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            globsMatchers.add(FileSystems.getDefault().getPathMatcher("glob:" + glob));
        }
        try (Stream<Path> paths = Files.walk(outputDirectory.resolve("assets"), new FileVisitOption[0]);){
            paths.filter(path -> path.toString().endsWith(".json") && globsMatchers.stream().anyMatch(matcher -> matcher.matches((Path)path))).forEach(path -> {
                try {
                    Path relativePath = outputDirectory.relativize((Path)path);
                    Path targetPath = outputDirectory.resolve("packed").resolve(relativePath);
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(path);
                    LOGGER.info("Successfully packed file: {}", (Object)relativePath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy file: " + String.valueOf(path), e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to traverse assets directory", e);
        }
    }
}

