/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.mru.packing.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackedResourcePack
implements PackResources {
    private final String modID;
    private final Path packPath;
    private final Logger logger;
    private final String packName;
    private final Set<String> namespaces = new HashSet<String>();
    @Nullable
    private final String readme;

    public UnpackedResourcePack(String modID, Path packPath, String packName, @Nullable String readme) {
        this.modID = modID;
        this.packPath = packPath;
        this.packName = packName;
        this.readme = readme;
        this.logger = LoggerFactory.getLogger((String)("MRU/UnpackedResourcePack/" + packName));
    }

    public String getModID() {
        return this.modID;
    }

    @Nullable
    public String getReadme() {
        return this.readme;
    }

    @ApiStatus.Internal
    public void walkNamespaces() {
        this.logger.info("Walking resource pack namespaces...");
        try {
            this.namespaces.clear();
            @NotNull Path assetsFolder = this.packPath.resolve("assets");
            if (!assetsFolder.toFile().exists() || !assetsFolder.toFile().isDirectory()) {
                return;
            }
            try (@NotNull Stream<Path> assets = Files.list(assetsFolder);){
                assets.forEach(namespace -> {
                    if (namespace.toFile().isDirectory()) {
                        this.namespaces.add(namespace.getFileName().toString());
                        this.logger.info("Found namespace: {}", (Object)namespace.getFileName().toString());
                    }
                });
            }
        }
        catch (IOException e) {
            this.logger.error("Error occurred while walking resource pack namespaces: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        Path filePath = this.packPath.resolve(fileName);
        if (filePath.toFile().exists()) {
            return () -> Files.newInputStream(filePath, new OpenOption[0]);
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        return this.m_8017_(type.m_10305_() + "/" + id.m_135827_() + "/" + id.m_135815_());
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        String start = String.valueOf(this.packPath) + "/" + type.m_10305_() + "/" + namespace + "/" + prefix;
        String[] files = new File(start).list();
        if (files == null || files.length == 0) {
            return;
        }
        List<ResourceLocation> resultList = Arrays.stream(files).map(file -> ResourceLocation.m_214293_((String)namespace, (String)(prefix + "/" + file))).toList();
        for (ResourceLocation result : resultList) {
            consumer.accept((Object)result, this.m_214146_(type, result));
        }
    }

    @NotNull
    public Set<String> m_5698_(PackType packType) {
        return this.namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        IoSupplier<InputStream> inputSupplier = this.m_8017_("pack.mcmeta");
        if (inputSupplier != null) {
            try (InputStream input = (InputStream)inputSupplier.m_247737_();){
                Object object = AbstractPackResources.m_10214_(metaReader, (InputStream)input);
                return (T)object;
            }
        }
        return null;
    }

    public String m_5542_() {
        return this.packName;
    }

    public void close() {
    }

    public Path getPackPath() {
        return this.packPath;
    }

    public String getPackName() {
        return this.packName;
    }
}

