/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.LevelChunkTicks;

public class FakeChunk
extends LevelChunk {
    private boolean isTainted;
    public DataLayer[] blockLight;
    public DataLayer[] skyLight;
    public ListTag serializedBlockEntities;

    public FakeChunk(Level world, ChunkPos pos, LevelChunkSection[] sections) {
        super(world, pos, UpgradeData.f_63320_, new LevelChunkTicks(), new LevelChunkTicks(), 0L, sections, null, null);
    }

    public void setTainted(boolean enabled) {
        if (this.isTainted == enabled) {
            return;
        }
        this.isTainted = enabled;
        Minecraft client = Minecraft.m_91087_();
        double gamma = (Double)client.f_91066_.m_231927_().m_231551_();
        LevelRenderer worldRenderer = client.f_91060_;
        LevelLightEngine lightingProvider = this.m_62953_().m_5518_();
        ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.BLOCK));
        ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.SKY));
        int blockDelta = enabled ? 5 : 0;
        int skyDelta = enabled ? -3 + (int)(-7.0 * gamma) : 0;
        int x = this.m_7697_().f_45578_;
        int z = this.m_7697_().f_45579_;
        for (int y = this.m_151560_(); y < this.m_151561_(); ++y) {
            this.updateTaintedState(blockLightProvider, x, y, z, blockDelta);
            this.updateTaintedState(skyLightProvider, x, y, z, skyDelta);
            worldRenderer.m_109770_(x, y, z);
        }
    }

    private void updateTaintedState(ChunkLightProviderExt lightProvider, int x, int y, int z, int delta) {
        if (lightProvider == null) {
            return;
        }
        lightProvider.bobby_setTainted(SectionPos.m_123209_((int)x, (int)y, (int)z), delta);
    }

    public void setHeightmap(Heightmap.Types type, Heightmap heightmap) {
        this.f_187608_.put(type, heightmap);
    }
}

