/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import fuzs.puzzleslib.api.core.v1.Buildable;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializer;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV3 {
    public static Builder builder(String modId) {
        return ModContext.get(modId).getNetworkHandlerV3$Builder();
    }

    public <T extends Record> Packet<ClientGamePacketListener> toClientboundPacket(T var1);

    public <T extends Record> Packet<ServerGamePacketListener> toServerboundPacket(T var1);

    default public <T extends Record> void sendToServer(T message) {
        Proxy.INSTANCE.getClientConnection().m_129512_(this.toServerboundPacket(message));
    }

    default public <T extends Record> void sendTo(ServerPlayer player, T message) {
        player.f_8906_.m_9829_(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAll(T message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllExcept(ServerPlayer exclude, T message) {
        for (ServerPlayer player : Proxy.INSTANCE.getGameServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            this.sendTo(player, message);
        }
    }

    default public <T extends Record> void sendToAllNear(BlockPos pos, Level level, T message) {
        this.sendToAllNearExcept(null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNear(double posX, double posY, double posZ, double distance, Level level, T message) {
        this.sendToAllNearExcept(null, posX, posY, posZ, 64.0, level, message);
    }

    default public <T extends Record> void sendToAllNearExcept(@Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level, T message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTracking(Entity entity, T message) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToAllTrackingAndSelf(Entity entity, T message) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, this.toClientboundPacket(message));
    }

    default public <T extends Record> void sendToDimension(Level level, T message) {
        this.sendToDimension((ResourceKey<Level>)level.m_46472_(), message);
    }

    default public <T extends Record> void sendToDimension(ResourceKey<Level> dimension, T message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    Buildable {
        default public <T> Builder registerSerializer(Class<T> type, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader) {
            MessageSerializers.registerSerializer(type, writer, reader);
            return this;
        }

        default public <T> Builder registerSerializer(Class<? super T> type, ResourceKey<Registry<T>> resourceKey) {
            MessageSerializers.registerSerializer(type, resourceKey);
            return this;
        }

        default public <T> Builder registerContainerProvider(Class<T> type, Function<Type[], MessageSerializer<? extends T>> factory) {
            MessageSerializers.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        public Builder clientAcceptsVanillaOrMissing();

        public Builder serverAcceptsVanillaOrMissing();

        default public Builder allAcceptVanillaOrMissing() {
            return this.clientAcceptsVanillaOrMissing().serverAcceptsVanillaOrMissing();
        }
    }
}

