/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.impl.client.init.ItemDisplayOverridesImpl;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.BakedModelWrapper;

public final class ForgeItemDisplayOverrides
extends ItemDisplayOverridesImpl {
    public ForgeItemDisplayOverrides() {
        ModelEvents.modifyBakingResult("puzzleslib").register((models, modelBakery) -> {
            for (final Map.Entry entry : this.overrideLocations.entrySet()) {
                final BakedModel itemModel = (BakedModel)models.get(entry.getKey());
                Objects.requireNonNull(itemModel, "item model is null");
                models.put((ResourceLocation)entry.getKey(), new BakedModelWrapper<BakedModel>(itemModel){
                    private final Map<ItemDisplayContext, BakedModel> overrides;
                    {
                        super(originalModel);
                        this.overrides = (Map)Stream.of(ItemDisplayContext.values()).collect(Maps.toImmutableEnumMap(Function.identity(), context -> {
                            if (((Map)entry.getValue()).containsKey(context)) {
                                BakedModel itemModelOverride = (BakedModel)models.get(((Map)entry.getValue()).get(context));
                                Objects.requireNonNull(itemModelOverride, "item model override is null");
                                return itemModelOverride;
                            }
                            return itemModel;
                        }));
                    }

                    public BakedModel applyTransform(ItemDisplayContext itemDisplayContext, PoseStack poseStack, boolean applyLeftHandTransform) {
                        return this.overrides.get(itemDisplayContext).applyTransform(itemDisplayContext, poseStack, applyLeftHandTransform);
                    }
                });
            }
        });
    }
}

