/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PickupHandler;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.scripting.ScriptReloadListener;
import tschipp.carryon.events.EntityPickupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="carryon")
public class CommonEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.f_46443_) {
            return;
        }
        boolean success = false;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickUpBlock((ServerPlayer)player, pos, level, (pState, pPos) -> {
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(level, pPos, pState, player);
                MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                return !breakEvent.isCanceled();
            })) {
                success = true;
            }
        } else {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                PlacementHandler.tryPlaceBlock((ServerPlayer)player, pos, event.getFace(), (pos2, state) -> {
                    BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos2);
                    BlockEvent.EntityPlaceEvent event1 = new BlockEvent.EntityPlaceEvent(snapshot, level.m_8055_(pos), (Entity)player);
                    MinecraftForge.EVENT_BUS.post((Event)event1);
                    return !event1.isCanceled();
                });
            } else {
                PlacementHandler.tryPlaceEntity((ServerPlayer)player, pos, event.getFace(), (pPos, toPlace) -> {
                    if (toPlace instanceof Mob) {
                        Mob mob = (Mob)toPlace;
                        MobSpawnEvent.FinalizeSpawn checkSpawn = new MobSpawnEvent.FinalizeSpawn(mob, (ServerLevelAccessor)level, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, level.m_6436_(new BlockPos((int)pPos.f_82479_, (int)pPos.f_82480_, (int)pPos.f_82481_)), MobSpawnType.EVENT, null, null, null);
                        MinecraftForge.EVENT_BUS.post((Event)checkSpawn);
                        return event.getResult() != Event.Result.DENY;
                    }
                    return true;
                });
            }
            success = true;
        }
        if (success) {
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        Entity target = event.getTarget();
        if (level.f_46443_) {
            return;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickupEntity((ServerPlayer)player, target, toPickup -> {
                EntityPickupEvent pickupEvent = new EntityPickupEvent((ServerPlayer)player, (Entity)toPickup);
                MinecraftForge.EVENT_BUS.post((Event)pickupEvent);
                return !pickupEvent.isCanceled();
            })) {
                event.setResult(Event.Result.DENY);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            PlacementHandler.tryStackEntity((ServerPlayer)player, target);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CarryOnCommon.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onDatapackRegister(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ScriptReloadListener());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            for (ServerPlayer p : event.getPlayerList().m_11314_()) {
                ScriptReloadListener.syncScriptsWithClient(p);
            }
        } else {
            ScriptReloadListener.syncScriptsWithClient(player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                CarryOnCommon.onCarryTick(player);
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.getOriginal().m_9236_().f_46443_) {
            PlacementHandler.placeCarriedOnDeath((ServerPlayer)event.getOriginal(), (ServerPlayer)event.getEntity(), event.isWasDeath());
        }
    }

    @SubscribeEvent
    public static void harvestSpeed(PlayerEvent.BreakSpeed event) {
        if (!CarryOnCommon.onTryBreakBlock(event.getEntity())) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        if (!CarryOnCommon.onAttackedByPlayer(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!CarryOnCommon.onTryBreakBlock(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CarryOnCommon.onPlayerAttacked(player);
        }
    }
}

