/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class CraftingButton
extends GuiImageButton {
    private AbstractSpellPart abstractSpellPart = null;
    public List<SpellValidationError> validationErrors = new LinkedList<SpellValidationError>();

    public CraftingButton(int x, int y, Button.OnPress onPress) {
        super(x, y, 0, 0, 22, 20, 22, 20, "textures/gui/spell_glyph_slot.png", onPress);
    }

    public void clear() {
        this.validationErrors.clear();
        this.abstractSpellPart = null;
    }

    @Nullable
    public AbstractSpellPart getAbstractSpellPart() {
        return this.abstractSpellPart;
    }

    public void setAbstractSpellPart(AbstractSpellPart abstractSpellPart) {
        this.abstractSpellPart = abstractSpellPart;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int parX, int parY, float partialTicks) {
        if (this.f_93624_) {
            if (this.validationErrors.isEmpty()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            if (this.abstractSpellPart != null) {
                RenderUtils.drawSpellPart(this.abstractSpellPart, graphics, this.f_93620_ + 3, this.f_93621_ + 2, 16, !this.validationErrors.isEmpty(), 0);
            }
        }
        super.m_88315_(graphics, parX, parY, partialTicks);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.abstractSpellPart != null) {
            tooltip.add((Component)Component.m_237115_((String)this.abstractSpellPart.getLocalizationKey()));
            for (SpellValidationError ve : this.validationErrors) {
                tooltip.add((Component)ve.makeTextComponentExisting().m_130940_(ChatFormatting.RED));
            }
        }
    }
}

