/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism_integrations.VampirismCompat;
import de.teamlapen.vampirism_integrations.VampirismIntegrationsMod;
import de.teamlapen.vampirism_integrations.util.IModCompat;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismIntegrationsMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            LOGGER.warn("Version check is not finished yet");
        }
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().m_6982_() || UtilLib.isPlayerOp((Player)event.getEntity());
        if (!((Boolean)VampirismCompat.disableVersionCheck.get()).booleanValue() && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || event.getEntity().m_217043_().m_188503_(5) == 0) && event.getEntity().m_217043_().m_188503_(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            event.getEntity().m_5661_((Component)Component.m_237110_((String)"text.vampirism.outdated", (Object[])new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}), false);
            MutableComponent download = Component.m_237115_((String)"text.vampirism.update_message.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl())).m_131157_(ChatFormatting.UNDERLINE).m_131140_(ChatFormatting.BLUE));
            MutableComponent changelog = Component.m_237115_((String)"text.vampirism.update_message.changelog").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).m_131157_(ChatFormatting.UNDERLINE));
            MutableComponent modpage = Component.m_237115_((String)"text.vampirism.update_message.modpage").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, versionInfo.getHomePage())).m_131157_(ChatFormatting.UNDERLINE).m_131140_(ChatFormatting.BLUE));
            event.getEntity().m_5661_((Component)download.m_130946_(" ").m_7220_((Component)changelog).m_130946_(" ").m_7220_((Component)modpage), false);
        }
        if (isAdminLikePlayer && event.getEntity().m_217043_().m_188503_(4) == 0) {
            List<IModCompat> list = VampirismIntegrationsMod.instance.compatLoader.getIncompatibleCompats();
            for (IModCompat m : list) {
                Optional mod = ModList.get().getModContainerById(m.getModID());
                mod.ifPresent(modcontainer -> event.getEntity().m_5661_((Component)Component.m_237113_((String)String.format("Could not load Vampirism mod compat for %s because version %s is incompatible (Accepted %s)", m.getModID(), modcontainer.getModInfo().getVersion(), m.getAcceptedVersionRange())), false));
            }
        }
    }
}

