/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism_integrations.mca.MCACompat;
import de.teamlapen.vampirism_integrations.mca.MCARegistration;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.Gender;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AggressiveVillagerEntityMCA
extends VillagerEntityMCA
implements IAggressiveVillager {
    @Nullable
    private ICaptureAttributes villageAttributes;

    @Nullable
    public static Villager makeAngry(VillagerEntityMCA villager) {
        if (villager.getProfession() == ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("mca:guard")) || villager.getProfession() == ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("mca:outlaw")) || villager.isInfected()) {
            return null;
        }
        EntityType t = villager.getGenetics().getGender() == Gender.FEMALE ? (EntityType)MCARegistration.FEMALE_AGGRESSIVE_VILLAGER.get() : (EntityType)MCARegistration.MALE_AGGRESSIVE_VILLAGER.get();
        Villager angry = (Villager)t.m_20615_(villager.m_9236_());
        if (angry == null) {
            return null;
        }
        angry.m_20361_((Entity)villager);
        if (ModList.get().getModContainerById("vampirism").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(version -> version.getMinorVersion() <= 9 && version.getIncrementalVersion() <= 3).orElse(true).booleanValue()) {
            villager.m_146870_();
        }
        return angry;
    }

    public AggressiveVillagerEntityMCA(EntityType<AggressiveVillagerEntityMCA> type, Level w, Gender gender) {
        super(type, w, gender);
    }

    public void attackVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    public void defendVillage(ICaptureAttributes villageAttributes) {
        this.villageAttributes = villageAttributes;
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.PITCHFORK.get()));
        return data;
    }

    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @javax.annotation.Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    public boolean isAttackingVillage() {
        return false;
    }

    public boolean isDefendingVillage() {
        return this.villageAttributes != null;
    }

    public void stopVillageAttackDefense() {
        LivingEntity villager = (LivingEntity)(this.getGenetics().getGender() == Gender.FEMALE ? (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MCACompat.FEMALE_VILLAGER) : (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MCACompat.MALE_VILLAGER)).m_20615_(this.m_9236_());
        assert (villager != null);
        this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        villager.m_20361_((Entity)this);
        if (ModList.get().getModContainerById("vampirism").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(version -> version.getMinorVersion() <= 9 && version.getIncrementalVersion() <= 3).orElse(true).booleanValue()) {
            this.m_146870_();
        }
        UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)villager);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.55, false, 400, () -> true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.f_21346_.m_25352_(3, (Goal)new DefendVillageGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal<PathfinderMob>((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double m_7623_() {
                return super.m_7623_() / 2.0;
            }
        });
    }
}

