/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.event.bus.IZetaPlayEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZAddReloadListener;
import org.violetmoon.zeta.event.load.ZTagsUpdated;
import org.violetmoon.zeta.event.play.ZRecipeCrawl;
import org.violetmoon.zeta.event.play.ZServerTick;
import org.violetmoon.zeta.mod.ZetaMod;

@ApiStatus.Internal
public class RecipeCrawlHandler {
    private static final List<Recipe<?>> vanillaRecipesToLazyDigest = new ArrayList();
    private static final Multimap<Item, ItemStack> vanillaRecipeDigestion = HashMultimap.create();
    private static final Multimap<Item, ItemStack> backwardsVanillaDigestion = HashMultimap.create();
    private static final Object mutex = new Object();
    private static boolean needsCrawl = false;
    private static boolean mayCrawl = false;

    @PlayEvent
    public static void addListener(ZAddReloadListener event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager mgr, ProfilerFiller prof) {
                RecipeCrawlHandler.clear();
                return null;
            }

            protected void apply(Void what, ResourceManager mgr, ProfilerFiller prof) {
                needsCrawl = true;
            }
        });
    }

    @PlayEvent
    public static void tagsHaveUpdated(ZTagsUpdated event) {
        mayCrawl = true;
    }

    private static void clear() {
        mayCrawl = false;
        RecipeCrawlHandler.fire(new ZRecipeCrawl.Reset());
    }

    private static void fire(IZetaPlayEvent event) {
        ZetaMod.ZETA.playBus.fire(event);
    }

    private static void load(RecipeManager manager, RegistryAccess access) {
        if (!manager.m_44051_().isEmpty()) {
            RecipeCrawlHandler.fire(new ZRecipeCrawl.Starting());
            vanillaRecipesToLazyDigest.clear();
            vanillaRecipeDigestion.clear();
            backwardsVanillaDigestion.clear();
            for (Recipe recipe : manager.m_44051_()) {
                try {
                    ZRecipeCrawl.Visit event;
                    if (recipe == null) {
                        throw new IllegalStateException("Recipe is null");
                    }
                    if (recipe.m_7527_() == null) {
                        throw new IllegalStateException("Recipe ingredients are null");
                    }
                    if (recipe.m_8043_(access) == null) {
                        throw new IllegalStateException("Recipe getResultItem is null");
                    }
                    boolean isMisc = false;
                    if (recipe instanceof ShapedRecipe) {
                        ShapedRecipe sr = (ShapedRecipe)recipe;
                        event = new ZRecipeCrawl.Visit.Shaped(sr, access);
                    } else if (recipe instanceof ShapelessRecipe) {
                        ShapelessRecipe sr = (ShapelessRecipe)recipe;
                        event = new ZRecipeCrawl.Visit.Shapeless(sr, access);
                    } else if (recipe instanceof CustomRecipe) {
                        CustomRecipe cr = (CustomRecipe)recipe;
                        event = new ZRecipeCrawl.Visit.Custom(cr, access);
                    } else if (recipe instanceof AbstractCookingRecipe) {
                        AbstractCookingRecipe acr = (AbstractCookingRecipe)recipe;
                        event = new ZRecipeCrawl.Visit.Cooking(acr, access);
                    } else {
                        event = new ZRecipeCrawl.Visit.Misc(recipe, access);
                        isMisc = true;
                    }
                    if (!isMisc) {
                        vanillaRecipesToLazyDigest.add(recipe);
                    }
                    RecipeCrawlHandler.fire(event);
                }
                catch (Exception e) {
                    if (recipe == null) {
                        ZetaMod.LOGGER.error("Encountered null recipe in RecipeManager.getRecipes. This is not good");
                        continue;
                    }
                    ZetaMod.LOGGER.error("Failed to scan recipe " + recipe.m_6423_() + ". This should be reported to " + recipe.m_6423_().m_135827_() + "!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlayEvent
    public static void onTick(ZServerTick.Start tick) {
        Object object = mutex;
        synchronized (object) {
            if (mayCrawl && needsCrawl) {
                RecipeManager manager = tick.getServer().m_129894_();
                RegistryAccess.Frozen access = tick.getServer().m_206579_();
                RecipeCrawlHandler.load(manager, (RegistryAccess)access);
                needsCrawl = false;
            }
            if (!vanillaRecipesToLazyDigest.isEmpty()) {
                vanillaRecipeDigestion.clear();
                backwardsVanillaDigestion.clear();
                for (Recipe<?> recipe : vanillaRecipesToLazyDigest) {
                    RecipeCrawlHandler.digest(recipe, (RegistryAccess)tick.getServer().m_206579_());
                }
                vanillaRecipesToLazyDigest.clear();
                RecipeCrawlHandler.fire(new ZRecipeCrawl.Digest(vanillaRecipeDigestion, backwardsVanillaDigestion));
            }
        }
    }

    private static void digest(Recipe<?> recipe, RegistryAccess access) {
        ItemStack out = recipe.m_8043_(access);
        Item outItem = out.m_41720_();
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack inStack : ingredient.m_43908_()) {
                if (!inStack.getCraftingRemainingItem().m_41619_()) continue;
                vanillaRecipeDigestion.put((Object)inStack.m_41720_(), (Object)out);
                backwardsVanillaDigestion.put((Object)outItem, (Object)inStack);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public void recursivelyFindCraftedItemsFromStrings(@Nullable Collection<String> derivationList, @Nullable Collection<String> whitelist, @Nullable Collection<String> blacklist, Consumer<Item> callback) {
    }

    @Deprecated(forRemoval=true)
    public void recursivelyFindCraftedItems(@Nullable Collection<Item> derivationList, @Nullable Collection<Item> whitelist, @Nullable Collection<Item> blacklist, Consumer<Item> callback) {
    }
}

