/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules.support;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.areas.Area;
import mcjty.incontrol.areas.AreaSystem;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.events.EventsSystem;
import mcjty.incontrol.rules.support.CountInfo;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.setup.ModSetup;
import mcjty.incontrol.spawner.SpawnerSystem;
import mcjty.incontrol.tools.cache.StructureCache;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.TestingBlockTools;
import mcjty.incontrol.tools.rules.TestingTools;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class GenericRuleEvaluator {
    private static final Random rnd = new Random();
    private final List<BiFunction<Object, IEventQuery, Boolean>> checks = new ArrayList<BiFunction<Object, IEventQuery, Boolean>>();
    private final IModRuleCompatibilityLayer compatibility = new ModRuleCompatibilityLayer();

    public GenericRuleEvaluator(AttributeMap map) {
        this.addChecks(map);
    }

    private void addChecks(AttributeMap map) {
        map.consume(RuleKeys.RANDOM, this::addRandomCheck);
        map.consumeAsList(RuleKeys.DIMENSION, this::addDimensionCheck);
        map.consumeAsList(RuleKeys.DIMENSION_MOD, this::addDimensionModCheck);
        map.consume(RuleKeys.TIME, this::addTimeCheck);
        map.consume(RuleKeys.MINTIME, this::addMinTimeCheck);
        map.consume(RuleKeys.MAXTIME, this::addMaxTimeCheck);
        map.consume(RuleKeys.HEIGHT, this::addHeightCheck);
        map.consume(RuleKeys.MINHEIGHT, this::addMinHeightCheck);
        map.consume(RuleKeys.MAXHEIGHT, this::addMaxHeightCheck);
        map.consumeAsList(RuleKeys.SOURCE, this::addSourceCheck);
        map.consumeAsList(RuleKeys.MOD, this::addModsCheck);
        map.consume(RuleKeys.WEATHER, this::addWeatherCheck);
        map.consumeAsList(RuleKeys.BIOMETAGS, this::addBiomeTagCheck);
        map.consume(RuleKeys.DIFFICULTY, this::addDifficultyCheck);
        map.consume(RuleKeys.MINSPAWNDIST, this::addMinSpawnDistCheck);
        map.consume(RuleKeys.MAXSPAWNDIST, this::addMaxSpawnDistCheck);
        map.consume(RuleKeys.LIGHT, this::addLightCheck);
        map.consume(RuleKeys.MINLIGHT, this::addMinLightCheck);
        map.consume(RuleKeys.MAXLIGHT, this::addMaxLightCheck);
        map.consume(RuleKeys.MINLIGHT_FULL, this::addMinLightCheckCorrect);
        map.consume(RuleKeys.MAXLIGHT_FULL, this::addMaxLightCheckCorrect);
        map.consume(RuleKeys.MINDIFFICULTY, this::addMinAdditionalDifficultyCheck);
        map.consume(RuleKeys.MAXDIFFICULTY, this::addMaxAdditionalDifficultyCheck);
        map.consume(RuleKeys.SEESKY, this::addSeeSkyCheck);
        map.consume(RuleKeys.SLIME, this::addSlimeChunkCheck);
        map.consume(RuleKeys.AREA, this::addAreaCheck);
        map.consumeAsList(RuleKeys.BLOCK, b1 -> this.addBlocksCheck(map, (List<String>)b1));
        map.consumeAsList(RuleKeys.BIOME, this::addBiomesCheck);
        map.consumeAsList(RuleKeys.BIOMETYPE, this::addBiomeTypesCheck);
        map.consumeAsList(RuleKeys.HELMET, this::addHelmetCheck);
        map.consumeAsList(RuleKeys.CHESTPLATE, this::addChestplateCheck);
        map.consumeAsList(RuleKeys.LEGGINGS, this::addLeggingsCheck);
        map.consumeAsList(RuleKeys.BOOTS, this::addBootsCheck);
        map.consumeAsList(RuleKeys.PLAYER_HELDITEM, items -> this.addHeldItemCheck((List<String>)items, false));
        map.consumeAsList(RuleKeys.HELDITEM, items -> this.addHeldItemCheck((List<String>)items, false));
        map.consumeAsList(RuleKeys.OFFHANDITEM, items -> this.addOffHandItemCheck((List<String>)items, false));
        map.consumeAsList(RuleKeys.BOTHHANDSITEM, this::addBothHandsItemCheck);
        map.consumeAsList(RuleKeys.LACKHELMET, this::addHelmetCheckLacking);
        map.consumeAsList(RuleKeys.LACKCHESTPLATE, this::addChestplateCheckLacking);
        map.consumeAsList(RuleKeys.LACKLEGGINGS, this::addLeggingsCheckLacking);
        map.consumeAsList(RuleKeys.LACKBOOTS, this::addBootsCheckLacking);
        map.consumeAsList(RuleKeys.LACKHELDITEM, items -> this.addHeldItemCheck((List<String>)items, true));
        map.consumeAsList(RuleKeys.LACKOFFHANDITEM, items -> this.addOffHandItemCheck((List<String>)items, true));
        map.consume(RuleKeys.HASSTRUCTURE, this::addHasStructureCheck);
        map.consumeAsList(RuleKeys.STRUCTURE, this::addStructureCheck);
        map.consumeAsList(RuleKeys.STRUCTURETAGS, this::addStructureTagsCheck);
        map.consumeAsList(RuleKeys.SCOREBOARDTAGS_ALL, this::addAllScoreboardTagsCheck);
        map.consumeAsList(RuleKeys.SCOREBOARDTAGS_ANY, this::addAnyScoreboardTagsCheck);
        map.consume(RuleKeys.STATE, this::addStateCheck);
        map.consume(RuleKeys.PSTATE, this::addPStateCheck);
        map.consume(RuleKeys.SUMMER, this::addSummerCheck);
        map.consume(RuleKeys.WINTER, this::addWinterCheck);
        map.consume(RuleKeys.SPRING, this::addSpringCheck);
        map.consume(RuleKeys.AUTUMN, this::addAutumnCheck);
        map.consume(RuleKeys.GAMESTAGE, this::addGameStageCheck);
        map.consume(RuleKeys.INCITY, this::addInCityCheck);
        map.consume(RuleKeys.INSTREET, this::addInStreetCheck);
        map.consume(RuleKeys.INSPHERE, this::addInSphereCheck);
        map.consume(RuleKeys.INBUILDING, this::addInBuildingCheck);
        map.consumeAsList(RuleKeys.BUILDING, this::addBuildingCheck);
        map.consumeAsList(RuleKeys.AMULET, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getAmuletSlots));
        map.consumeAsList(RuleKeys.RING, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getRingSlots));
        map.consumeAsList(RuleKeys.BELT, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getBeltSlots));
        map.consumeAsList(RuleKeys.TRINKET, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getTrinketSlots));
        map.consumeAsList(RuleKeys.HEAD, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getHeadSlots));
        map.consumeAsList(RuleKeys.BODY, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getBodySlots));
        map.consumeAsList(RuleKeys.CHARM, v -> this.addBaubleCheck((List<String>)v, this.compatibility::getCharmSlots));
        map.consume(RuleKeys.WHEN, b -> {});
        map.consume(RuleKeys.PHASE, b -> {});
        map.consume(RuleKeys.NUMBER, this::addNumberCheck);
        map.consume(RuleKeys.HOSTILE, this::addHostileCheck);
        map.consume(RuleKeys.PASSIVE, this::addPassiveCheck);
        map.consume(RuleKeys.BABY, this::addBabyCheck);
        map.consume(RuleKeys.CANSPAWNHERE, this::addCanSpawnHereCheck);
        map.consume(RuleKeys.NOTCOLLIDING, this::addNotCollidingCheck);
        map.consume(RuleKeys.SPAWNER, this::addSpawnerCheck);
        map.consume(RuleKeys.INCONTROL, this::addInControlCheck);
        map.consume(RuleKeys.EVENTSPAWN, this::addEventSpawnCheck);
        map.consumeAsList(RuleKeys.MOB, this::addMobsCheck);
        map.consume(RuleKeys.PLAYER, this::addPlayerCheck);
        map.consume(RuleKeys.REALPLAYER, this::addRealPlayerCheck);
        map.consume(RuleKeys.FAKEPLAYER, this::addFakePlayerCheck);
        map.consume(RuleKeys.EXPLOSION, this::addExplosionCheck);
        map.consume(RuleKeys.PROJECTILE, this::addProjectileCheck);
        map.consume(RuleKeys.FIRE, this::addFireCheck);
        map.consume(RuleKeys.MAGIC, this::addMagicCheck);
        map.consume(RuleKeys.MINCOUNT, this::addMinCountCheck);
        map.consume(RuleKeys.MAXCOUNT, this::addMaxCountCheck);
        map.consume(RuleKeys.DAYCOUNT, this::addDayCountCheck);
        map.consume(RuleKeys.MINDAYCOUNT, this::addMinDayCountCheck);
        map.consume(RuleKeys.MAXDAYCOUNT, this::addMaxDayCountCheck);
        map.consume(RuleKeys.CAVE, this::addCaveCheck);
    }

    private void addNumberCheck(String json) {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        TestingTools.NumberResult result = TestingTools.parseNumberCheck(element);
        if (result != null) {
            this.checks.add((event, query) -> {
                DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(query.getWorld(event)));
                return result.test().test(data.getNumber(result.number()));
            });
        }
    }

    private void addCanSpawnHereCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof Mob) {
                    BlockPos pos = entity.m_20183_();
                    Level world = entity.m_20193_();
                    if (TestingTools.isChunkInvalid((LevelAccessor)world, pos)) {
                        return false;
                    }
                    return Mob.m_217057_((EntityType)entity.m_6095_(), (LevelAccessor)world, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, null);
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof Mob) {
                    BlockPos pos = entity.m_20183_();
                    Level world = entity.m_20193_();
                    if (TestingTools.isChunkInvalid((LevelAccessor)world, pos)) {
                        return false;
                    }
                    return !Mob.m_217057_((EntityType)entity.m_6095_(), (LevelAccessor)world, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, null);
                }
                return true;
            });
        }
    }

    private void addNotCollidingCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof Mob) {
                    BlockPos pos = entity.m_20183_();
                    Level world = entity.m_20193_();
                    if (TestingTools.isChunkInvalid((LevelAccessor)world, pos)) {
                        return false;
                    }
                    return ((Mob)entity).m_6914_((LevelReader)world);
                }
                return false;
            });
        } else {
            this.checks.add((event, query) -> {
                Entity entity = query.getEntity(event);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    BlockPos pos = entity.m_20183_();
                    Level world = entity.m_20193_();
                    if (TestingTools.isChunkInvalid((LevelAccessor)world, pos)) {
                        return false;
                    }
                    return !mob.m_6914_((LevelReader)world);
                }
                return true;
            });
        }
    }

    private void addInControlCheck(boolean c) {
        this.checks.add((event, query) -> c == (SpawnerSystem.busySpawning != null));
    }

    private void addEventSpawnCheck(boolean c) {
        this.checks.add((event, query) -> c == (EventsSystem.busySpawning != null));
    }

    private void addSpawnerCheck(boolean c) {
        if (c) {
            this.checks.add((event, query) -> {
                Mob mob;
                if (event instanceof MobSpawnEvent.FinalizeSpawn) {
                    MobSpawnEvent.FinalizeSpawn checkSpawn = (MobSpawnEvent.FinalizeSpawn)event;
                    return checkSpawn.getSpawnType().equals((Object)MobSpawnType.SPAWNER);
                }
                if (event instanceof MobSpawnEvent.PositionCheck) {
                    MobSpawnEvent.PositionCheck checkSpawn = (MobSpawnEvent.PositionCheck)event;
                    return checkSpawn.getSpawnType().equals((Object)MobSpawnType.SPAWNER);
                }
                Entity patt12025$temp = query.getEntity(event);
                return patt12025$temp instanceof Mob && Objects.equals((mob = (Mob)patt12025$temp).getSpawnType(), MobSpawnType.SPAWNER);
            });
        } else {
            this.checks.add((event, query) -> {
                Mob mob;
                if (event instanceof MobSpawnEvent.FinalizeSpawn) {
                    MobSpawnEvent.FinalizeSpawn checkSpawn = (MobSpawnEvent.FinalizeSpawn)event;
                    return !checkSpawn.getSpawnType().equals((Object)MobSpawnType.SPAWNER);
                }
                if (event instanceof MobSpawnEvent.PositionCheck) {
                    MobSpawnEvent.PositionCheck checkSpawn = (MobSpawnEvent.PositionCheck)event;
                    return !checkSpawn.getSpawnType().equals((Object)MobSpawnType.SPAWNER);
                }
                Entity patt12609$temp = query.getEntity(event);
                return !(patt12609$temp instanceof Mob && Objects.equals((mob = (Mob)patt12609$temp).getSpawnType(), MobSpawnType.SPAWNER));
            });
        }
    }

    private void addBabyCheck(boolean baby) {
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living.m_6162_() == baby;
            }
            return false;
        });
    }

    private void addHostileCheck(boolean hostile) {
        if (hostile) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof Enemy);
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof Enemy));
        }
    }

    private void addPassiveCheck(boolean passive) {
        if (passive) {
            this.checks.add((event, query) -> query.getEntity(event) instanceof Animal && !(query.getEntity(event) instanceof Enemy));
        } else {
            this.checks.add((event, query) -> !(query.getEntity(event) instanceof Animal) || query.getEntity(event) instanceof Enemy);
        }
    }

    private void addMobsCheck(List<String> mobs) {
        if (mobs.size() == 1) {
            EntityType type;
            String id = mobs.get(0);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(id))) {
                ErrorHandler.error("Unknown mob '" + id + "'!");
            }
            if ((type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id))) != null) {
                this.checks.add((event, query) -> type.equals(query.getEntity(event).m_6095_()));
            }
        } else {
            HashSet<EntityType> classes = new HashSet<EntityType>();
            for (String id : mobs) {
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id));
                if (type != null) {
                    classes.add(type);
                    continue;
                }
                ErrorHandler.error("Unknown mob '" + id + "'!");
            }
            if (!classes.isEmpty()) {
                this.checks.add((event, query) -> classes.contains(query.getEntity(event).m_6095_()));
            }
        }
    }

    private void addModsCheck(List<String> mods) {
        if (mods.size() == 1) {
            String modid = mods.get(0);
            this.checks.add((event, query) -> {
                EntityType type = query.getEntity(event).m_6095_();
                String mod = ForgeRegistries.ENTITY_TYPES.getKey((Object)type).m_135827_();
                return modid.equals(mod);
            });
        } else {
            HashSet<String> modids = new HashSet<String>();
            modids.addAll(mods);
            this.checks.add((event, query) -> {
                EntityType type = query.getEntity(event).m_6095_();
                String mod = ForgeRegistries.ENTITY_TYPES.getKey((Object)type).m_135827_();
                return modids.contains(mod);
            });
        }
    }

    private void addRandomCheck(float r) {
        this.checks.add((event, query) -> rnd.nextFloat() < r);
    }

    private void addCaveCheck(boolean cave) {
        this.checks.add((event, query) -> {
            BlockPos pos;
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos = query.getPos(event))) {
                return false;
            }
            if (world.m_46861_(pos)) {
                return !cave;
            }
            int cnt = 0;
            block0: for (Direction direction : Direction.values()) {
                BlockPos p = pos;
                for (int i = 0; i < 50; ++i) {
                    BlockState state = world.m_8055_(p = p.m_121945_(direction));
                    if (state.m_204336_(ModSetup.CAVE_BLOCK)) {
                        ++cnt;
                        continue block0;
                    }
                    if (!state.m_60795_() && !state.m_60713_(Blocks.f_49990_) && !state.m_60713_(Blocks.f_49991_)) continue block0;
                }
            }
            return cnt >= 6 == cave;
        });
    }

    private void addSeeSkyCheck(boolean seesky) {
        if (seesky) {
            this.checks.add((event, query) -> {
                BlockPos pos;
                LevelAccessor world = query.getWorld(event);
                if (TestingTools.isChunkInvalid(world, pos = query.getPos(event))) {
                    return false;
                }
                return world.m_46861_(pos);
            });
        } else {
            this.checks.add((event, query) -> {
                BlockPos pos;
                LevelAccessor world = query.getWorld(event);
                if (TestingTools.isChunkInvalid(world, pos = query.getPos(event))) {
                    return false;
                }
                return !world.m_46861_(pos);
            });
        }
    }

    private void addSlimeChunkCheck(boolean slime) {
        if (slime) {
            this.checks.add((event, query) -> TestingTools.isSlimeChunk(new ChunkPos(query.getPos(event)), query.getWorld(event)));
        } else {
            this.checks.add((event, query) -> !TestingTools.isSlimeChunk(new ChunkPos(query.getPos(event)), query.getWorld(event)));
        }
    }

    private void addDimensionCheck(List<ResourceKey<Level>> dimensions) {
        if (dimensions.size() == 1) {
            ResourceKey<Level> dim = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).equals((Object)dim));
        } else {
            HashSet<ResourceKey<Level>> dims = new HashSet<ResourceKey<Level>>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event))));
        }
    }

    private void addDimensionModCheck(List<String> dimensions) {
        if (dimensions.size() == 1) {
            String dimmod = dimensions.get(0);
            this.checks.add((event, query) -> Tools.getDimensionKey(query.getWorld(event)).m_135782_().m_135827_().equals(dimmod));
        } else {
            HashSet<String> dims = new HashSet<String>(dimensions);
            this.checks.add((event, query) -> dims.contains(Tools.getDimensionKey(query.getWorld(event)).m_135782_().m_135827_()));
        }
    }

    private void addDifficultyCheck(String difficulty) {
        Difficulty diff = Difficulty.m_19031_((String)(difficulty = difficulty.toLowerCase()));
        if (diff != null) {
            Difficulty finalDiff = diff;
            this.checks.add((event, query) -> query.getWorld(event).m_46791_() == finalDiff);
        } else {
            ErrorHandler.error("Unknown difficulty '" + difficulty + "'! Use one of 'easy', 'normal', 'hard',  or 'peaceful'");
        }
    }

    private void addWeatherCheck(String weather) {
        boolean raining = weather.toLowerCase().startsWith("rain");
        boolean thunder = weather.toLowerCase().startsWith("thunder");
        if (raining) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    Level level = (Level)world;
                    return level.m_46471_();
                }
                return false;
            });
        } else if (thunder) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    Level level = (Level)world;
                    return level.m_46470_();
                }
                return false;
            });
        } else {
            ErrorHandler.error("Unknown weather '" + weather + "'! Use 'rain' or 'thunder'");
        }
    }

    private void addBiomeTagCheck(List<String> list) {
        Set tags = list.stream().map(s -> TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toSet());
        if (tags.size() == 1) {
            TagKey key = (TagKey)tags.iterator().next();
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                return biome.m_203656_(key);
            });
        } else {
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                for (TagKey tag : tags) {
                    if (!biome.m_203656_(tag)) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private void addAllScoreboardTagsCheck(List<String> list) {
        HashSet<String> tags = new HashSet<String>(list);
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living.m_19880_().containsAll(tags);
            }
            return false;
        });
    }

    private void addAnyScoreboardTagsCheck(List<String> list) {
        HashSet<String> tags = new HashSet<String>(list);
        this.checks.add((event, query) -> {
            Entity entity = query.getEntity(event);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living.m_19880_().stream().anyMatch(tags::contains);
            }
            return false;
        });
    }

    private void addHasStructureCheck(boolean c) {
        this.checks.add((event, query) -> StructureCache.CACHE.isInAnyStructure(query.getWorld(event), query.getPos(event)) == c);
    }

    private void addStructureCheck(List<String> structures) {
        if (structures.size() == 1) {
            String structure = structures.get(0);
            this.checks.add((event, query) -> StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event)));
        } else {
            HashSet<String> structureNames = new HashSet<String>(structures);
            this.checks.add((event, query) -> {
                for (String structure : structureNames) {
                    if (!StructureCache.CACHE.isInStructure(query.getWorld(event), structure, query.getPos(event))) continue;
                    return true;
                }
                return false;
            });
        }
    }

    private void addStructureTagsCheck(List<String> tags) {
        Set tagSet = tags.stream().map(s -> TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toSet());
        this.checks.add((event, query) -> {
            BlockPos pos;
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos = query.getPos(event))) {
                return false;
            }
            ChunkAccess chunk = world.m_46865_(pos);
            if (chunk == null) {
                return false;
            }
            Map references = chunk.m_62769_();
            for (Map.Entry e : references.entrySet()) {
                LongSet longs = (LongSet)e.getValue();
                if (longs.isEmpty()) continue;
                Structure struct = (Structure)e.getKey();
                Optional resourceKey = world.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)struct);
                if (!resourceKey.isPresent()) continue;
                Holder.Reference holder = (Holder.Reference)world.m_9598_().m_175515_(Registries.f_256944_).m_203636_((ResourceKey)resourceKey.get()).get();
                for (TagKey tagKey : tagSet) {
                    if (!holder.m_203656_(tagKey)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private void addBiomesCheck(List<String> biomes) {
        if (biomes.size() == 1) {
            String biomename = biomes.get(0);
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                return Tools.getBiomeId((Holder<Biome>)biome).equals(biomename);
            });
        } else {
            HashSet<String> biomenames = new HashSet<String>(biomes);
            this.checks.add((event, query) -> {
                Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
                String biomeId = Tools.getBiomeId((Holder<Biome>)biome);
                return biomenames.contains(biomeId);
            });
        }
    }

    private void addBiomeTypesCheck(List<String> biomeTypes) {
        HashSet biomes = new HashSet();
        biomeTypes.stream().map(s -> BiomeManager.BiomeType.valueOf((String)s.toUpperCase())).forEach(type -> BiomeManager.getBiomes((BiomeManager.BiomeType)type).forEach(t -> biomes.add((Biome)ForgeRegistries.BIOMES.getValue(t.getKey().m_211136_()))));
        this.checks.add((event, query) -> {
            Holder biome = query.getWorld(event).m_204166_(query.getPos(event));
            return biomes.contains(biome.m_203334_());
        });
    }

    private void addBlocksCheck(AttributeMap map, List<String> blocks) {
        String bo = map.consumeAndFetch(RuleKeys.BLOCKOFFSET);
        BiFunction<Object, IEventQuery, BlockPos> posFunction = bo != null ? TestingBlockTools.parseOffset(bo) : (event, query) -> query.getValidBlockPos(event);
        if (blocks.size() == 1) {
            String json = blocks.get(0);
            BiPredicate<LevelAccessor, BlockPos> blockMatcher = TestingBlockTools.parseBlock(json);
            if (blockMatcher != null) {
                this.checks.add((event, query) -> {
                    BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                    return pos != null && blockMatcher.test(query.getWorld(event), pos);
                });
            }
        } else {
            ArrayList<BiPredicate<LevelAccessor, BlockPos>> blockMatchers = new ArrayList<BiPredicate<LevelAccessor, BlockPos>>();
            for (String block : blocks) {
                BiPredicate<LevelAccessor, BlockPos> blockMatcher = TestingBlockTools.parseBlock(block);
                if (blockMatcher == null) {
                    return;
                }
                blockMatchers.add(blockMatcher);
            }
            this.checks.add((event, query) -> {
                BlockPos pos = (BlockPos)posFunction.apply(event, (IEventQuery)query);
                if (pos != null) {
                    LevelAccessor world = query.getWorld(event);
                    for (BiPredicate matcher : blockMatchers) {
                        if (!matcher.test(world, pos)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    private void addTimeCheck(String time) {
        Predicate<Integer> expression = Tools.parseExpression(time);
        if (expression != null) {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                if (world instanceof Level) {
                    long t = ((Level)world).m_46468_();
                    return expression.test((int)(t % 24000L));
                }
                return false;
            });
        }
    }

    private void addMinTimeCheck(int mintime) {
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            if (world instanceof Level) {
                long time = ((Level)world).m_46468_();
                return time % 24000L >= (long)mintime;
            }
            return false;
        });
    }

    private void addMaxTimeCheck(int maxtime) {
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            if (world instanceof Level) {
                long time = ((Level)world).m_46468_();
                return time % 24000L <= (long)maxtime;
            }
            return false;
        });
    }

    private void addMinSpawnDistCheck(float v) {
        float d = v * v;
        this.checks.add((event, query) -> {
            ServerLevel sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.m_123331_((Vec3i)(sw = Tools.getServerWorld(query.getWorld(event))).m_220360_());
            return sqdist >= (double)d;
        });
    }

    private void addMaxSpawnDistCheck(float v) {
        float d = v * v;
        this.checks.add((event, query) -> {
            ServerLevel sw;
            BlockPos pos = query.getPos(event);
            double sqdist = pos.m_123331_((Vec3i)(sw = Tools.getServerWorld(query.getWorld(event))).m_220360_());
            return sqdist <= (double)d;
        });
    }

    private void addLightCheck(String expression) {
        Predicate<Integer> exp = Tools.parseExpression(expression);
        if (exp != null) {
            this.checks.add((event, query) -> {
                BlockPos pos = query.getPos(event);
                LevelAccessor world = query.getWorld(event);
                if (TestingTools.isChunkInvalid(world, pos)) {
                    return false;
                }
                return exp.test(world.m_45517_(LightLayer.BLOCK, pos));
            });
        }
    }

    private void addMinLightCheck(int minlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos)) {
                return false;
            }
            return world.m_45517_(LightLayer.BLOCK, pos) >= minlight;
        });
    }

    private void addMinLightCheckCorrect(int minlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos)) {
                return false;
            }
            return world.m_46803_(pos) >= minlight;
        });
    }

    private void addMaxLightCheck(int maxlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos)) {
                return false;
            }
            return world.m_45517_(LightLayer.BLOCK, pos) <= maxlight;
        });
    }

    private void addMaxLightCheckCorrect(int maxlight) {
        this.checks.add((event, query) -> {
            BlockPos pos = query.getPos(event);
            LevelAccessor world = query.getWorld(event);
            if (TestingTools.isChunkInvalid(world, pos)) {
                return false;
            }
            return world.m_46803_(pos) <= maxlight;
        });
    }

    private void addMinAdditionalDifficultyCheck(Float mindifficulty) {
        this.checks.add((event, query) -> query.getWorld(event).m_6436_(query.getPos(event)).m_19056_() >= mindifficulty.floatValue());
    }

    private void addMaxAdditionalDifficultyCheck(Float maxdifficulty) {
        this.checks.add((event, query) -> query.getWorld(event).m_6436_(query.getPos(event)).m_19056_() <= maxdifficulty.floatValue());
    }

    private void addHeightCheck(String input) {
        Predicate<Integer> expression = Tools.parseExpression(input);
        if (expression != null) {
            this.checks.add((event, query) -> expression.test(query.getY(event)));
        }
    }

    private void addMaxHeightCheck(int maxheight) {
        this.checks.add((event, query) -> query.getY(event) <= maxheight);
    }

    private void addMinHeightCheck(int minheight) {
        this.checks.add((event, query) -> query.getY(event) >= minheight);
    }

    private void addHelmetCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.HEAD, false);
    }

    private void addChestplateCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.CHEST, false);
    }

    private void addLeggingsCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.LEGS, false);
    }

    private void addBootsCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.FEET, false);
    }

    private void addHelmetCheckLacking(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.HEAD, true);
    }

    private void addChestplateCheckLacking(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.CHEST, true);
    }

    private void addLeggingsCheckLacking(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.LEGS, true);
    }

    private void addBootsCheckLacking(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.addArmorCheck(items, EquipmentSlot.FEET, true);
    }

    private void addArmorCheck(List<Predicate<ItemStack>> items, EquipmentSlot slot, boolean lacking) {
        this.checks.add((event, query) -> {
            ItemStack armorItem;
            Player player = query.getPlayer(event);
            if (player != null && !(armorItem = player.m_6844_(slot)).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(armorItem)) continue;
                    return !lacking;
                }
            }
            return lacking;
        });
    }

    private void addHeldItemCheck(List<String> itemList, boolean lacking) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.checks.add((event, query) -> {
            ItemStack mainhand;
            Player player = query.getPlayer(event);
            if (player != null && !(mainhand = player.m_21205_()).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(mainhand)) continue;
                    return !lacking;
                }
            }
            return lacking;
        });
    }

    private void addOffHandItemCheck(List<String> itemList, boolean lacking) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.checks.add((event, query) -> {
            ItemStack offhand;
            Player player = query.getPlayer(event);
            if (player != null && !(offhand = player.m_21206_()).m_41619_()) {
                for (Predicate item : items) {
                    if (!item.test(offhand)) continue;
                    return !lacking;
                }
            }
            return lacking;
        });
    }

    private void addBothHandsItemCheck(List<String> itemList) {
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.checks.add((event, query) -> {
            Player player = query.getPlayer(event);
            if (player != null) {
                ItemStack mainhand;
                ItemStack offhand = player.m_21206_();
                if (!offhand.m_41619_()) {
                    for (Predicate item : items) {
                        if (!item.test(offhand)) continue;
                        return true;
                    }
                }
                if (!(mainhand = player.m_21205_()).m_41619_()) {
                    for (Predicate item : items) {
                        if (!item.test(mainhand)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addStateCheck(String s) {
        if (!this.compatibility.hasEnigmaScript()) {
            TestingTools.warn("EnigmaScript is missing: this test cannot work!");
            return;
        }
        try {
            String[] split = StringUtils.split((String)s, (char)'=');
            String state = split[0];
            String value = split[1];
            this.checks.add((event, query) -> value.equals(this.compatibility.getState(query.getWorld(event), state)));
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
        }
    }

    private void addPStateCheck(String s) {
        if (!this.compatibility.hasEnigmaScript()) {
            TestingTools.warn("EnigmaScript is missing: this test cannot work!");
            return;
        }
        try {
            String[] split = StringUtils.split((String)s, (char)'=');
            String state = split[0];
            String value = split[1];
            this.checks.add((event, query) -> value.equals(this.compatibility.getPlayerState(query.getPlayer(event), state)));
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
        }
    }

    private void addSummerCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            TestingTools.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSummer((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addWinterCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            TestingTools.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isWinter((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addSpringCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            TestingTools.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isSpring((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addAutumnCheck(Boolean s) {
        if (!this.compatibility.hasSereneSeasons()) {
            TestingTools.warn("Serene Seasons is missing: this test cannot work!");
            return;
        }
        this.checks.add((event, query) -> s.booleanValue() == this.compatibility.isAutumn((Level)Tools.getServerWorld(query.getWorld(event))));
    }

    private void addGameStageCheck(String stage) {
        if (!this.compatibility.hasGameStages()) {
            TestingTools.warn("Game Stages is missing: the 'gamestage' test cannot work!");
            return;
        }
        this.checks.add((event, query) -> this.compatibility.hasGameStage(query.getPlayer(event), stage));
    }

    private void addInCityCheck(boolean incity) {
        if (!this.compatibility.hasLostCities()) {
            TestingTools.warn("The Lost Cities is missing: the 'incity' test cannot work!");
            return;
        }
        if (incity) {
            this.checks.add((event, query) -> this.compatibility.isCity(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isCity(query, event));
        }
    }

    private void addInStreetCheck(boolean instreet) {
        if (!this.compatibility.hasLostCities()) {
            TestingTools.warn("The Lost Cities is missing: the 'instreet' test cannot work!");
            return;
        }
        if (instreet) {
            this.checks.add((event, query) -> this.compatibility.isStreet(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isStreet(query, event));
        }
    }

    private void addInSphereCheck(boolean insphere) {
        if (!this.compatibility.hasLostCities()) {
            TestingTools.warn("The Lost Cities is missing: the 'insphere' test cannot work!");
            return;
        }
        if (insphere) {
            this.checks.add((event, query) -> this.compatibility.inSphere(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.inSphere(query, event));
        }
    }

    private void addInBuildingCheck(boolean inbuilding) {
        if (!this.compatibility.hasLostCities()) {
            TestingTools.warn("The Lost Cities is missing: the 'inbuilding' test cannot work!");
            return;
        }
        if (inbuilding) {
            this.checks.add((event, query) -> this.compatibility.isBuilding(query, event));
        } else {
            this.checks.add((event, query) -> !this.compatibility.isBuilding(query, event));
        }
    }

    private void addBuildingCheck(List<String> buildings) {
        if (!this.compatibility.hasLostCities()) {
            TestingTools.warn("The Lost Cities is missing: the 'building' test cannot work!");
            return;
        }
        HashSet<String> buildingSet = new HashSet<String>(buildings);
        this.checks.add((event, query) -> {
            String building = this.compatibility.getBuilding(query, event);
            return building != null && buildingSet.contains(building);
        });
    }

    private void addBaubleCheck(List<String> itemList, Supplier<int[]> slotSupplier) {
        if (!this.compatibility.hasBaubles()) {
            TestingTools.warn("Baubles is missing: this test cannot work!");
            return;
        }
        List<Predicate<ItemStack>> items = TestingTools.getItems(itemList);
        this.checks.add((event, query) -> {
            Player player = query.getPlayer(event);
            if (player != null) {
                for (int slot : (int[])slotSupplier.get()) {
                    ItemStack stack = this.compatibility.getBaubleStack(player, slot);
                    if (stack.m_41619_()) continue;
                    for (Predicate item : items) {
                        if (!item.test(stack)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    private void addMinCountCheck(String json) {
        CountInfo info = CountInfo.parseCountInfo(json);
        if (info == null) {
            return;
        }
        BiFunction<LevelAccessor, Entity, Integer> counter = info.getCounter();
        Function<LevelAccessor, Integer> amountAdjuster = CountInfo.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            LevelAccessor world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count >= (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private void addMaxCountCheck(String json) {
        CountInfo info = CountInfo.parseCountInfo(json);
        BiFunction<LevelAccessor, Entity, Integer> counter = info.getCounter();
        Function<LevelAccessor, Integer> amountAdjuster = CountInfo.getAmountAdjuster(info, info.amount);
        this.checks.add((event, query) -> {
            int amount;
            Entity entity;
            LevelAccessor world = query.getWorld(event);
            int count = (Integer)counter.apply(world, entity = query.getEntity(event));
            return count < (amount = ((Integer)amountAdjuster.apply(world)).intValue());
        });
    }

    private void addDayCountCheck(Object count) {
        if (count == null) {
            return;
        }
        if (count instanceof Integer) {
            Integer c = (Integer)count;
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(world));
                int amount = data.getDaycounter();
                return amount % c == 0;
            });
        } else if (count instanceof String) {
            String input = (String)count;
            Predicate<Integer> expression = Tools.parseExpression(input);
            if (expression == null) {
                return;
            }
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(world));
                int amount = data.getDaycounter();
                return expression.test(amount);
            });
        }
    }

    private void addMinDayCountCheck(Integer count) {
        if (count == null) {
            return;
        }
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(world));
            int amount = data.getDaycounter();
            return amount >= count;
        });
    }

    private void addMaxDayCountCheck(Integer count) {
        if (count == null) {
            return;
        }
        this.checks.add((event, query) -> {
            LevelAccessor world = query.getWorld(event);
            DataStorage data = DataStorage.getData((LevelAccessor)Tools.getServerWorld(world));
            int amount = data.getDaycounter();
            return amount < count;
        });
    }

    private void addPlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof Player);
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) instanceof Player);
        }
    }

    private void addRealPlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : TestingTools.isRealPlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !TestingTools.isRealPlayer(query.getAttacker(event)));
        }
    }

    private void addFakePlayerCheck(boolean asPlayer) {
        if (asPlayer) {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? false : TestingTools.isFakePlayer(query.getAttacker(event)));
        } else {
            this.checks.add((event, query) -> query.getAttacker(event) == null ? true : !TestingTools.isFakePlayer(query.getAttacker(event)));
        }
    }

    private void addExplosionCheck(boolean explosion) {
        if (explosion) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).m_276093_(DamageTypes.f_268565_));
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).m_276093_(DamageTypes.f_268565_));
        }
    }

    private void addProjectileCheck(boolean projectile) {
        if (projectile) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).m_276093_(DamageTypes.f_268565_));
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).m_276093_(DamageTypes.f_268565_));
        }
    }

    private void addFireCheck(boolean fire) {
        if (fire) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).m_276093_(DamageTypes.f_268631_));
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).m_276093_(DamageTypes.f_268631_));
        }
    }

    private void addMagicCheck(boolean magic) {
        if (magic) {
            this.checks.add((event, query) -> query.getSource(event) == null ? false : query.getSource(event).m_276093_(DamageTypes.f_268515_));
        } else {
            this.checks.add((event, query) -> query.getSource(event) == null ? true : !query.getSource(event).m_276093_(DamageTypes.f_268515_));
        }
    }

    private void addSourceCheck(List<String> sources) {
        HashSet<String> sourceSet = new HashSet<String>(sources);
        this.checks.add((event, query) -> {
            if (query.getSource(event) == null) {
                return false;
            }
            return sourceSet.contains(query.getSource(event).m_19385_());
        });
    }

    private void addAreaCheck(String areaName) {
        Area area = AreaSystem.getArea(areaName);
        if (area == null) {
            ErrorHandler.error("Cannot find area '" + areaName + "'!");
        } else {
            this.checks.add((event, query) -> {
                LevelAccessor world = query.getWorld(event);
                ResourceKey<Level> key = Tools.getDimensionKey(world);
                if (area.dimension() == key) {
                    BlockPos pos = query.getPos(event);
                    return area.isInArea(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                }
                return false;
            });
        }
    }

    public boolean match(Object event, IEventQuery query) {
        for (BiFunction<Object, IEventQuery, Boolean> rule : this.checks) {
            if (rule.apply(event, query).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

