/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppClientPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;

public class BlackboardBlockTileRenderer
implements BlockEntityRenderer<BlackboardBlockTile> {
    public static final int WIDTH = 6;
    private final Minecraft mc = Minecraft.m_91087_();
    private final Camera camera;
    private final boolean noise;

    public BlackboardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.camera = this.mc.f_91063_.m_109153_();
        this.noise = MiscUtils.FESTIVITY.isAprilsFool() && PlatHelper.getPlatform().isForge();
    }

    public int m_142163_() {
        return this.noise ? 64 : 8;
    }

    public boolean shouldRender(BlackboardBlockTile blockEntity, Vec3 cameraPos) {
        return super.m_142756_((BlockEntity)blockEntity, cameraPos);
    }

    public void render(BlackboardBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int combinedOverlayIn) {
        LocalPlayer player;
        BlockHitResult blockHit;
        if (!CommonConfigs.Building.BLACKBOARD_MODE.get().canManualDraw() && !this.noise) {
            return;
        }
        Direction dir = tile.getDirection();
        float yaw = -dir.m_122435_();
        Vec3 cameraPos = this.camera.m_90583_();
        BlockPos pos = tile.m_58899_();
        if (this.noise) {
            int lu = light & 0xFFFF;
            int lv = light >> 16 & 0xFFFF;
            SuppClientPlatformStuff.getNoiseShader().m_173348_("Intensity").m_5985_(1.0f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(RotHlpr.rot((Direction)dir));
            poseStack.m_85837_(-0.5, -0.5, 0.1865);
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.m_119194_(bufferSource, SuppClientPlatformStuff::staticNoise);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (int)255, (int)255, (int)lu, (int)lv);
            poseStack.m_85849_();
            return;
        }
        if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)pos, (float)yaw, (float)0.0f, (Direction)dir, (float)0.375f)) {
            return;
        }
        HitResult hit = this.mc.f_91077_;
        if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).m_82425_().equals((Object)pos) && tile.getDirection() == blockHit.m_82434_() && (player = this.mc.f_91074_) != null && Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)player.m_21205_()) && BlackboardBlock.getStackChalkColor(player.m_21205_()) != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(RotHlpr.rot((Direction)dir));
            poseStack.m_85837_(-0.5, -0.5, 0.1865);
            int lu = light & 0xFFFF;
            int lv = light >> 16 & 0xFFFF;
            Vector2i pair = BlackboardBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)pair.x() * p;
            float y = (float)pair.y() * p;
            VertexConsumer builder = ModMaterials.BLACKBOARD_OUTLINE.m_119194_(bufferSource, RenderType::m_110452_);
            poseStack.m_252880_(1.0f - x - p, 1.0f - y - p, 0.0f);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)0.0f, (float)0.0f, (float)p, (float)p, (int)lu, (int)lv);
            poseStack.m_85849_();
        }
    }
}

