/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.block_models.JarBakedModel;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JarBlockTileRenderer
extends CageBlockTileRenderer<JarBlockTile> {
    private final ItemRenderer itemRenderer;
    private static final boolean USE_MODEL = false;

    public JarBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
    }

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource bufferIn, int light, int combinedOverlayIn) {
        poseStack.m_85836_();
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        VertexConsumer builder = ModMaterials.get(texture).m_119194_(bufferIn, RenderType::m_110470_);
        Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
        poseStack.m_85837_(0.5, (double)dimensions.z(), 0.5);
        VertexUtil.addCube((VertexConsumer)builder, (PoseStack)poseStack, (float)dimensions.x(), (float)(percentageFill * dimensions.y()), (int)light, (int)color);
        poseStack.m_85849_();
    }

    public void render(JarBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SoftFluidTank tank;
        long r = tile.m_58899_().m_121878_();
        RandomSource rand = RandomSource.m_216335_((long)r);
        AtomicInteger i = new AtomicInteger();
        JarBlockTileRenderer.renderCookies(poseStack, bufferIn, rand, combinedLightIn, combinedOverlayIn, () -> {
            int j = i.getAndIncrement();
            return j < tile.m_6643_() ? tile.m_8020_(j) : ItemStack.f_41583_;
        });
        MobContainer.MobNBTData data = tile.mobContainer.getData();
        if (data != null) {
            if (data.is2DFish()) {
                poseStack.m_85836_();
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * Mth.m_14031_((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                poseStack.m_85837_(0.5, 0.5, 0.5);
                Quaternionf rotation = Axis.f_252436_.m_252977_(-angle);
                poseStack.m_252781_(rotation);
                poseStack.m_85841_(0.625f, 0.625f, 0.625f);
                Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                poseStack.m_85837_(0.0, -0.2, -0.335 * (double)(dimensions.x() / 0.5f));
                int fishType = data.getFishTexture();
                VertexUtils.renderFish(bufferIn, poseStack, wo, ho, fishType, combinedLightIn);
                poseStack.m_85849_();
            } else {
                super.m_6922_(tile, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            Optional<Holder<SoftFluid>> fluid = tile.mobContainer.shouldRenderWithFluid();
            if (fluid != null && fluid.isPresent()) {
                if (fluid.get().m_203373_(BuiltInSoftFluids.WATER.getID())) {
                    poseStack.m_85836_();
                    Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                    poseStack.m_85837_(0.5, 0.0015 + (double)dimensions.z(), 0.5);
                    VertexConsumer builder = ModMaterials.SAND_MATERIAL.m_119194_(bufferIn, RenderType::m_110452_);
                    VertexUtil.addCube((VertexConsumer)builder, (PoseStack)poseStack, (float)(0.99f * dimensions.x()), (float)(dimensions.y() / 12.0f), (int)combinedLightIn, (int)-1);
                    poseStack.m_85849_();
                }
                poseStack.m_85836_();
                SoftFluid s = (SoftFluid)fluid.get().m_203334_();
                JarBlockTileRenderer.renderFluid(0.75f, s.getTintColor(), 0, s.getStillTexture(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
                poseStack.m_85849_();
            }
        }
        if (!(tank = tile.fluidHolder).isEmpty()) {
            SoftFluid fluid = tank.getFluidValue();
            JarBlockTileRenderer.renderFluid(tank.getHeight(1.0f), tank.getCachedStillColor((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_()), fluid.getLuminosity(), fluid.getStillTexture(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void renderCookies(PoseStack poseStack, MultiBufferSource buffer, RandomSource rand, int light, int overlay, Supplier<ItemStack> itemIterator) {
        ItemStack cookieStack = itemIterator.get();
        if (!cookieStack.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(RotHlpr.XN90);
            poseStack.m_85837_(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            poseStack.m_85841_(scale, scale, scale);
            do {
                poseStack.m_252781_(Axis.f_252403_.m_252977_((float)rand.m_188503_(360)));
                poseStack.m_252880_(0.0f, 0.0f, 1.0f / (16.0f * scale));
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel model = itemRenderer.m_174264_(cookieStack, null, null, 0);
                itemRenderer.m_115143_(cookieStack, ItemDisplayContext.FIXED, true, poseStack, buffer, light, overlay, model);
            } while (!(cookieStack = itemIterator.get()).m_41619_());
            poseStack.m_85849_();
        }
    }
}

