/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureMapCommand {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.locate.structure.invalid", (Object[])new Object[]{object}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"structure_map").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256944_)).executes(c -> StructureMapCommand.giveMap((CommandContext<CommandSourceStack>)c, 2))).then(Commands.m_82129_((String)"zoom", (ArgumentType)IntegerArgumentType.integer()).executes(c -> StructureMapCommand.giveMap((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"zoom")))));
    }

    public static int giveMap(CommandContext<CommandSourceStack> context, int zoom) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        ResourceOrTagKeyArgument.Result structure = ResourceOrTagKeyArgument.m_246379_(context, (String)"structure", (ResourceKey)Registries.f_256944_, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        HolderSet<Structure> holderSet = StructureMapCommand.getHolders((ResourceOrTagKeyArgument.Result<Structure>)structure, (Registry<Structure>)registry).orElseThrow(() -> ERROR_STRUCTURE_INVALID.create((Object)structure.m_245390_()));
        ServerPlayer p = source.m_230896_();
        if (p != null) {
            ItemStack item = AdventurerMapsHandler.createMapOrQuill(level, p.m_20097_(), holderSet, 150, true, zoom, null, null, 0);
            p.m_36356_(item);
        }
        return 0;
    }

    private static Optional<? extends HolderSet<Structure>> getHolders(ResourceOrTagKeyArgument.Result<Structure> structure, Registry<Structure> structureRegistry) {
        Objects.requireNonNull(structureRegistry);
        return (Optional)structure.m_245276_().map(res -> structureRegistry.m_203636_(res).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> structureRegistry.m_203431_(arg_0));
    }
}

