/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.pipe;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.PipeBlockEntity;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.MiscUtil;

public abstract class BasePipeBlock
extends ZetaBlock
implements EntityBlock {
    protected static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    protected static final BooleanProperty UP = BlockStateProperties.f_61366_;
    protected static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    protected static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    protected static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    protected static final BooleanProperty EAST = BlockStateProperties.f_61369_;

    protected static BooleanProperty property(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    protected BasePipeBlock(String name, SoundType soundType, @Nullable ZetaModule module) {
        this(name, module, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.HAT).m_60913_(3.0f, 10.0f).m_60918_(soundType).m_60955_());
    }

    protected BasePipeBlock(String name, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(name, module, properties);
        this.m_49959_(this.getDefaultPipeState());
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.f_257028_);
        module.zeta.renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
    }

    public BlockState getDefaultPipeState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false));
    }

    boolean isPipeWaterlogged(BlockState state) {
        return false;
    }

    public boolean allowsFullConnection(PipeBlockEntity.ConnectionType conn) {
        return conn.isSolid;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() == Items.f_42398_) {
            HashSet found = new HashSet();
            boolean fixedAny = false;
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            HashSet<BlockPos> newCandidates = new HashSet<BlockPos>();
            candidates.add(pos);
            do {
                for (BlockPos cand : candidates) {
                    for (Direction d : Direction.values()) {
                        BlockPos offPos = cand.m_121945_(d);
                        BlockState offState = worldIn.m_8055_(offPos);
                        if (offState.m_60734_() != this || candidates.contains(offPos) || found.contains(offPos)) continue;
                        newCandidates.add(offPos);
                    }
                    BlockState curr = worldIn.m_8055_(cand);
                    BlockState target = this.getTargetState((LevelAccessor)worldIn, cand);
                    if (target.equals(curr)) continue;
                    fixedAny = true;
                    worldIn.m_7731_(cand, target, 6);
                }
                found.addAll(candidates);
                candidates = newCandidates;
                newCandidates = new HashSet();
            } while (!candidates.isEmpty());
            if (fixedAny) {
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.m_61124_((Property)BasePipeBlock.property(dir), (Comparable)((Boolean)state.m_61143_((Property)BasePipeBlock.property(direction.m_55954_(dir)))));
        }
        return newState;
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.m_61124_((Property)BasePipeBlock.property(dir), (Comparable)((Boolean)state.m_61143_((Property)BasePipeBlock.property(mirror.m_54848_(dir)))));
        }
        return newState;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        for (Direction d : Direction.values()) {
            PipeBlockEntity.ConnectionType type = PipeBlockEntity.computeConnectionTo((BlockGetter)level, pos, d);
            boolean fullConnection = this.allowsFullConnection(type);
            state = (BlockState)state.m_61124_((Property)MiscUtil.directionProperty((Direction)d), (Comparable)Boolean.valueOf(fullConnection));
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
        return state;
    }

    public void m_6861_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pNeighborBlock, @NotNull BlockPos pNeighborPos, boolean pMovedByPiston) {
        super.m_6861_(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getTargetState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        this.refreshVisualConnections(level, pos);
        super.m_6402_(level, pos, state, entity, stack);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        this.refreshVisualConnections(pLevel, pPos);
    }

    public void refreshVisualConnections(Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity tile = (PipeBlockEntity)blockEntity;
            tile.refreshVisualConnections();
        }
    }

    protected BlockState getTargetState(LevelAccessor level, BlockPos pos) {
        BlockState newState = this.m_49966_();
        for (Direction facing : Direction.values()) {
            PipeBlockEntity.ConnectionType type = PipeBlockEntity.computeConnectionTo((BlockGetter)level, pos, facing);
            newState = (BlockState)newState.m_61124_((Property)MiscUtil.directionProperty((Direction)facing), (Comparable)Boolean.valueOf(this.allowsFullConnection(type)));
        }
        return newState;
    }

    public static boolean isConnected(BlockState state, Direction side) {
        return (Boolean)state.m_61143_((Property)MiscUtil.directionProperty((Direction)side));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState blockState, Level worldIn, @NotNull BlockPos pos) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tile;
            return pipe.getComparatorOutput();
        }
        return 0;
    }

    public void m_6810_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be = worldIn.m_7702_(pos);
        if (be instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            pipe.dropAllItems();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return BasePipeBlock.createTickerHelper(type, PipesModule.blockEntityType, PipeBlockEntity::tick);
    }
}

