/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.Tags;
import org.violetmoon.quark.content.world.config.AirStoneClusterConfig;
import org.violetmoon.quark.content.world.config.BigStoneClusterConfig;
import org.violetmoon.quark.content.world.gen.BigStoneClusterGenerator;
import org.violetmoon.quark.content.world.module.NewStoneTypesModule;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class BigStoneClustersModule
extends ZetaModule {
    @Config
    public static BigStoneClusterConfig calcite = BigStoneClustersModule.bob(BiomeTags.f_207606_).build();
    @Config
    public static BigStoneClusterConfig limestone = BigStoneClustersModule.bob(Tags.Biomes.IS_SWAMP, BiomeTags.f_207603_).build();
    @Config
    public static BigStoneClusterConfig jasper = BigStoneClustersModule.bob(BiomeTags.f_207607_, Tags.Biomes.IS_SANDY).build();
    @Config
    public static BigStoneClusterConfig shale = BigStoneClustersModule.bob(Tags.Biomes.IS_SNOWY).build();
    @Config
    public static AirStoneClusterConfig myalite = ((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)((AirStoneClusterConfig.Builder)AirStoneClusterConfig.airStoneBuilder().generateInAir(true).dimensions(DimensionConfig.end((boolean)false))).biomes((IBiomeConfig)CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:end_highlands"}))).horizontalSize(20)).verticalSize(40)).horizontalVariation(6)).verticalVariation(10)).rarity(100)).minYLevel(58)).maxYLevel(62)).build();
    @Config(description="Blocks that stone clusters can replace. If you want to make it so it only replaces in one dimension,\ndo \"block|dimension\", as we do for netherrack and end stone by default.")
    public static List<String> blocksToReplace = Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:andesite", "minecraft:diorite", "minecraft:granite", "minecraft:netherrack|minecraft:the_nether", "minecraft:end_stone|minecraft:the_end", "quark:marble", "quark:limestone", "quark:jasper", "quark:slate"});
    public static BiPredicate<Level, Block> blockReplacePredicate = (w, b) -> false;

    @SafeVarargs
    private static BigStoneClusterConfig.Builder<?> bob(TagKey<Biome> ... tags) {
        return (BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)((BigStoneClusterConfig.Builder)BigStoneClusterConfig.stoneBuilder().dimensions(DimensionConfig.overworld((boolean)false))).horizontalSize(14)).verticalSize(14)).horizontalVariation(9)).verticalVariation(9)).rarity(4)).minYLevel(20)).maxYLevel(80)).biomeAllow(tags);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        this.add(calcite, Blocks.f_152497_, BooleanSuppliers.TRUE);
        this.add(limestone, NewStoneTypesModule.limestoneBlock, () -> NewStoneTypesModule.enabledWithLimestone);
        this.add(jasper, NewStoneTypesModule.jasperBlock, () -> NewStoneTypesModule.enabledWithJasper);
        this.add(shale, NewStoneTypesModule.shaleBlock, () -> NewStoneTypesModule.enabledWithShale);
        this.add(myalite, NewStoneTypesModule.myaliteBlock, () -> NewStoneTypesModule.enabledWithMyalite);
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints event) {
        if (BigStoneClustersModule.calcite.enabled) {
            event.hintItem(this.zeta, (ItemLike)Items.f_151047_, new Object[0]);
        }
    }

    private void add(BigStoneClusterConfig config, Block block, BooleanSupplier condition) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new BigStoneClusterGenerator(config, block.m_49966_(), condition), (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_DECORATION, (int)0);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        blockReplacePredicate = (b, w) -> false;
        Iterator<String> iterator = blocksToReplace.iterator();
        while (iterator.hasNext()) {
            String s;
            String bname = s = iterator.next();
            String dimension = null;
            if (bname.contains("|")) {
                String[] toks = bname.split("\\|");
                bname = toks[0];
                dimension = toks[1];
            }
            String dimFinal = dimension;
            BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(bname)).ifPresent(blockObj -> {
                if (blockObj != Blocks.f_50016_) {
                    blockReplacePredicate = dimFinal == null ? blockReplacePredicate.or((w, b) -> blockObj == b) : blockReplacePredicate.or((w, b) -> {
                        if (blockObj != b) {
                            return false;
                        }
                        if (w == null) {
                            return false;
                        }
                        return w.m_46472_().m_135782_().toString().equals(dimFinal);
                    });
                }
            });
        }
    }
}

