/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.battery;

import dynamic_fps.impl.feature.battery.BatteryTracker;
import dynamic_fps.impl.util.Localization;
import dynamic_fps.impl.util.ResourceLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BatteryToast
implements Toast {
    private long firstRender;
    private Component title;
    private Component description;
    private ResourceLocation icon;
    private static BatteryToast queuedToast;
    private static final ResourceLocation MOD_ICON;
    private static final ResourceLocation BACKGROUND_IMAGE;

    private BatteryToast(Component title, ResourceLocation icon) {
        this.title = title;
        this.icon = icon;
    }

    public static void queueToast(Component title, ResourceLocation icon) {
        if (queuedToast != null) {
            BatteryToast.queuedToast.title = title;
            BatteryToast.queuedToast.icon = icon;
        } else {
            queuedToast = new BatteryToast(title, icon);
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)queuedToast);
        }
    }

    @NotNull
    public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent toastComponent, long currentTime) {
        if (this.firstRender == 0L) {
            if (this == queuedToast) {
                queuedToast = null;
            }
            this.firstRender = currentTime;
            this.description = Localization.localized("toast", "battery_charge", BatteryTracker.charge());
        }
        graphics.m_280398_(BACKGROUND_IMAGE, 0, 0, 0, 0.0f, 0.0f, this.m_7828_(), this.m_94899_(), this.m_7828_(), this.m_94899_());
        graphics.m_280398_(MOD_ICON, 2, 2, 0, 0.0f, 0.0f, 8, 8, 8, 8);
        graphics.m_280398_(this.icon, 8, 8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280614_(toastComponent.m_94929_().f_91062_, this.title, 30, 7, 6238997, false);
        graphics.m_280614_(toastComponent.m_94929_().f_91062_, this.description, 30, 18, -16777216, false);
        return (double)(currentTime - this.firstRender) >= 5000.0 * toastComponent.m_264542_() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    static {
        MOD_ICON = ResourceLocations.of("dynamic_fps", "textures/battery/toast/background_icon.png");
        BACKGROUND_IMAGE = ResourceLocations.of("dynamic_fps", "textures/battery/toast/background.png");
    }
}

