/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.state;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.IdleCondition;
import dynamic_fps.impl.feature.battery.BatteryTracker;
import dynamic_fps.impl.service.Platform;
import net.lostluma.battery.api.State;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;

public class IdleHandler {
    private static boolean active = false;
    private static boolean wasIdle = false;
    private static long previousActivity = 0L;
    private static Vec3 prevPosition = Vec3.f_82478_;
    private static Vec3 prevLookAngle = Vec3.f_82478_;
    @Nullable
    private static GLFWKeyCallback previousKeyCallback;
    @Nullable
    private static GLFWScrollCallback previousScrollCallback;
    @Nullable
    private static GLFWCursorPosCallback previousCursorPosCallback;
    @Nullable
    private static GLFWMouseButtonCallback previousMouseClickCallback;

    public static void init() {
        if (active) {
            return;
        }
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        if (config.idle().timeout() == 0) {
            return;
        }
        if (config.idle().condition() == IdleCondition.ON_BATTERY && !BatteryTracker.hasBatteries()) {
            return;
        }
        active = true;
        if (DynamicFPSMod.getWindow() != null) {
            IdleHandler.setWindow(DynamicFPSMod.getWindow().address());
        }
        Platform.getInstance().registerStartTickEvent(IdleHandler::checkActivity);
    }

    public static void setWindow(long address) {
        if (active) {
            previousKeyCallback = GLFW.glfwSetKeyCallback((long)address, IdleHandler::onKey);
            previousScrollCallback = GLFW.glfwSetScrollCallback((long)address, IdleHandler::onScroll);
            previousCursorPosCallback = GLFW.glfwSetCursorPosCallback((long)address, IdleHandler::onMove);
            previousMouseClickCallback = GLFW.glfwSetMouseButtonCallback((long)address, IdleHandler::onPress);
        }
    }

    public static void onActivity() {
        previousActivity = Util.m_137574_();
    }

    public static boolean isIdle() {
        DynamicFPSConfig config = DynamicFPSConfig.INSTANCE;
        if (config.idle().timeout() == 0) {
            return false;
        }
        if (config.idle().condition() == IdleCondition.ON_BATTERY && BatteryTracker.status() != State.DISCHARGING) {
            return false;
        }
        return Util.m_137574_() - previousActivity >= (long)config.idle().timeout() * 1000L;
    }

    private static void checkActivity() {
        IdleHandler.checkPlayerActivity();
        boolean idle = IdleHandler.isIdle();
        if (idle != wasIdle) {
            wasIdle = idle;
            DynamicFPSMod.onStatusChanged(!idle);
        }
    }

    private static void checkPlayerActivity() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 position = player.m_20182_();
        Vec3 lookAngle = player.m_20154_();
        if (!position.equals((Object)prevPosition) || !lookAngle.equals((Object)prevLookAngle)) {
            IdleHandler.onActivity();
        }
        prevPosition = position;
        prevLookAngle = lookAngle;
    }

    private static void onKey(long address, int key, int scancode, int action, int mods) {
        IdleHandler.onActivity();
        if (previousKeyCallback != null) {
            previousKeyCallback.invoke(address, key, scancode, action, mods);
        }
    }

    private static void onScroll(long address, double xOffset, double yOffset) {
        IdleHandler.onActivity();
        if (previousScrollCallback != null) {
            previousScrollCallback.invoke(address, xOffset, yOffset);
        }
    }

    private static void onMove(long address, double x, double y) {
        IdleHandler.onActivity();
        if (previousCursorPosCallback != null) {
            previousCursorPosCallback.invoke(address, x, y);
        }
    }

    private static void onPress(long address, int button, int action, int mods) {
        IdleHandler.onActivity();
        if (previousMouseClickCallback != null) {
            previousMouseClickCallback.invoke(address, button, action, mods);
        }
    }
}

