/*
 * Decompiled with CFR 0.152.
 */
package net.lostluma.dynamic_fps.impl.forge.service;

import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.lostluma.dynamic_fps.impl.forge.DynamicFPSForgeMod;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgePlatform
implements Platform {
    @Override
    public String getName() {
        return "Forge";
    }

    @Override
    public Path getCacheDir() {
        Path base = FMLPaths.GAMEDIR.get();
        return this.ensureDir(base.resolve(".cache").resolve("dynamic_fps"));
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public Optional<Version> getModVersion(String modId) {
        Optional optional = ModList.get().getModContainerById(modId);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        String raw = ((ModContainer)optional.get()).getModInfo().getVersion().toString();
        try {
            return Optional.of(Version.of(raw));
        }
        catch (Version.VersionParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerStartTickEvent(Platform.StartTickEvent event) {
        DynamicFPSForgeMod.addTickEventListener(event);
    }

    private Path ensureDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Dynamic FPS directory.", e);
        }
        return path;
    }
}

