/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.nio.FloatBuffer;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.api.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.BufferUtils;

public class RenderHelper {
    public static void drawLine(GuiGraphics guiGraphics, int xBegin, int yBegin, int xEnd, int yEnd, int color) {
        guiGraphics.m_280509_(xBegin, yBegin, xEnd += xBegin == xEnd ? 1 : 0, yEnd += yBegin == yEnd ? 1 : 0, color);
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(guiGraphics.m_280168_().m_85850_().m_252922_());
        modelViewStack.m_252880_((float)x, (float)y, 50.0f);
        modelViewStack.m_85841_((float)(-scale), (float)scale, (float)scale);
        PoseStack mobPoseStack = new PoseStack();
        mobPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        mobPoseStack.m_252781_(Axis.f_252495_.m_252977_((float)Math.atan(pitch / 40.0) * 20.0f));
        livingEntity.f_19855_ = (float)Math.atan(yaw / 40.0) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.m_146922_(yRot);
        livingEntity.m_146922_(yRot);
        livingEntity.m_146926_(xRot);
        livingEntity.f_20885_ = yRot;
        livingEntity.f_20886_ = yRot;
        mobPoseStack.m_85837_(0.0, livingEntity.m_20186_(), 0.0);
        RenderSystem.applyModelViewMatrix();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderChest(GuiGraphics guiGraphics, float x, float y, float rotate, float scale, float lidAngle) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Resources.Vanilla.CHEST);
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(x, y, 50.0f);
        guiGraphics.m_280168_().m_252781_(new Quaternionf(-160.0f, 1.0f, 0.0f, 0.0f));
        guiGraphics.m_280168_().m_85841_(scale, -scale, -scale);
        guiGraphics.m_280168_().m_252880_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280168_().m_252781_(new Quaternionf(rotate, 0.0f, 1.0f, 0.0f));
        guiGraphics.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderBlock(GuiGraphics guiGraphics, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x, y, z);
        guiGraphics.m_280168_().m_85841_(-scale, -scale, -scale);
        guiGraphics.m_280168_().m_252880_(-0.5f, -0.5f, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        guiGraphics.m_280168_().m_252880_(0.5f, 0.0f, -0.5f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotate));
        guiGraphics.m_280168_().m_252880_(-0.5f, 0.0f, 0.5f);
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        mc.m_91289_().m_110912_(block, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85849_();
    }

    public static void scissor(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        double scale = Minecraft.m_91087_().m_91268_().m_85449_();
        double[] xyzTranslation = RenderHelper.getGLTranslation(guiGraphics, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.m_91087_().m_91268_().m_85442_() - y) - xyzTranslation[1]));
        int scissorW = Math.round(w - x);
        int scissorH = Math.round(h - y);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        RenderSystem.enableScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)Math.max(0, scissorInfo.width), (int)Math.max(0, scissorInfo.height));
    }

    public static void stopScissor() {
        RenderSystem.disableScissor();
    }

    public static void drawTexture(GuiGraphics guiGraphics, int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderHelper.drawTexturedModalRect(guiGraphics, x, y, u, v, width, height, 0.0f);
    }

    public static double[] getGLTranslation(GuiGraphics guiGraphics, double scale) {
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.set(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }

    public static double getGuiScaleFactor() {
        return Minecraft.m_91087_().m_91268_().m_85449_();
    }

    public static void drawTexturedModalRect(GuiGraphics guiGraphics, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder wr = tesselator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        wr.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tesselator.m_85914_();
    }
}

