/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.instances;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import fr.iglee42.createcasing.blockEntities.CustomMixerBlockEntity;
import fr.iglee42.createcasing.registries.ModPartialModels;
import net.minecraft.core.Direction;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomMixerInstance
extends EncasedCogInstance
implements DynamicInstance {
    private RotatingData mixerHead;
    private OrientedData mixerPole;
    private final CustomMixerBlockEntity mixer;

    public CustomMixerInstance(MaterialManager dispatcher, CustomMixerBlockEntity tile) {
        super(dispatcher, (KineticBlockEntity)tile, false);
        this.mixer = tile;
        RotatingData mixerHead = null;
        OrientedData mixerPole = (OrientedData)this.getOrientedMaterial().getModel(AllPartialModels.MECHANICAL_MIXER_POLE, this.blockState).createInstance();
        switch (ForgeRegistries.BLOCKS.getKey((Object)tile.m_58900_().m_60734_()).m_135815_().replace("_mixer", "").toLowerCase()) {
            case "brass": {
                mixerHead = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(ModPartialModels.BRASS_MIXER_HEAD, this.blockState).createInstance();
                break;
            }
            case "copper": {
                mixerHead = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(ModPartialModels.COPPER_MIXER_HEAD, this.blockState).createInstance();
                break;
            }
            case "railway": {
                mixerHead = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(ModPartialModels.RAILWAY_MIXER_HEAD, this.blockState).createInstance();
                break;
            }
            case "industrial_iron": {
                mixerHead = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(ModPartialModels.INDUSTRIAL_IRON_MIXER_HEAD, this.blockState).createInstance();
                break;
            }
            default: {
                mixerHead = (RotatingData)this.materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.MECHANICAL_MIXER_HEAD, this.blockState).createInstance();
            }
        }
        this.mixerHead = mixerHead;
        this.mixerPole = mixerPole;
        this.mixerHead.setRotationAxis(Direction.Axis.Y);
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    protected Instancer<RotatingData> getCogModel() {
        return this.materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.SHAFTLESS_COGWHEEL, ((KineticBlockEntity)this.blockEntity).m_58900_());
    }

    public void beginFrame() {
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    private void transformHead(float renderedHeadOffset) {
        float speed = this.mixer.getRenderedHeadRotationSpeed(AnimationTickHolder.getPartialTicks());
        this.mixerHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f);
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset() {
        return this.mixer.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos.m_7495_(), new FlatLit[]{this.mixerHead});
        this.relight(this.pos, new FlatLit[]{this.mixerPole});
    }

    public void remove() {
        super.remove();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }
}

